/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.auth;

import com.starbase.core.auth.api.AuthService;
import com.starbase.core.auth.api.ModuleAuthorizationService;
import com.starbase.core.auth.impl.AuthServiceImpl;
import com.starbase.core.auth.impl.ModuleAuthorizationServiceImpl;
import com.starbase.core.auth.impl.permission.PermissionHandler;
import com.starbase.core.auth.impl.ws.AccessViolationWS;
import com.starbase.core.auth.impl.ws.PermissionWebService;
import com.starbase.core.auth.impl.ws.UserWebService;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.webserver.api.HTTPService;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;

    public static LogService getLog() {
        return logServiceTracker.getService();
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        PermissionHandler.getInstance().load();
        context.registerService(AuthService.class, (Object)new AuthServiceImpl(), null);
        context.registerService(ModuleAuthorizationService.class, (Object)new ModuleAuthorizationServiceImpl(), null);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("auth", "true");
        ((Dictionary)properties).put("path", "/starbase/permission");
        context.registerService(new String[]{HTTPService.class.getName(), MappingServiceAware.class.getName()}, (Object)new PermissionWebService(), properties);
        ((Dictionary)properties).put("path", "/starbase/user");
        context.registerService(new String[]{HTTPService.class.getName(), MappingServiceAware.class.getName()}, (Object)new UserWebService(), properties);
        ((Dictionary)properties).put("path", "/starbase/access");
        context.registerService(new String[]{HTTPService.class.getName(), MappingServiceAware.class.getName()}, (Object)AccessViolationWS.getInstance(), properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        logServiceTracker.close();
        context = null;
    }
}

