/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.auth.impl.permission;

import com.starbase.core.auth.Activator;
import com.starbase.core.auth.dto.UserDTO;
import com.starbase.core.auth.impl.permission.CommunicationPermission;
import com.starbase.core.auth.impl.permission.MessagingPermission;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class PermissionHandler {
    private static final String PERMISSIONS_FILE = "permissions.txt";
    private static final String U_ID = "U";
    private static final String M_ID = "M";
    private static final String C_ID = "C";
    private static final String SEPARATOR = "|";
    private Hashtable<String, Set<MessagingPermission>> messagingPermissions = new Hashtable();
    private Hashtable<String, Set<CommunicationPermission>> communicationPermissions = new Hashtable();
    private HashMap<UserDTO, String> users = new HashMap();
    private static PermissionHandler instance;

    private PermissionHandler() {
    }

    public static PermissionHandler getInstance() {
        if (instance == null) {
            instance = new PermissionHandler();
        }
        return instance;
    }

    public Hashtable<String, Set<MessagingPermission>> getMessagingPermissions() {
        return this.messagingPermissions;
    }

    public Hashtable<String, Set<CommunicationPermission>> getCommunicationPermissions() {
        return this.communicationPermissions;
    }

    public HashMap<UserDTO, String> getUsers() {
        return this.users;
    }

    public void save() {
        AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                try (PrintWriter writer = null;){
                    Set perms;
                    File permissionFile = PermissionHandler.this.getPermissionFile();
                    if (!permissionFile.exists()) {
                        permissionFile.createNewFile();
                    }
                    writer = new PrintWriter(permissionFile, "UTF-8");
                    for (Map.Entry userEntry : PermissionHandler.this.users.entrySet()) {
                        writer.println("U|" + ((UserDTO)userEntry.getKey()).getName() + PermissionHandler.SEPARATOR + (String)userEntry.getValue());
                    }
                    for (Map.Entry msgPerm : PermissionHandler.this.messagingPermissions.entrySet()) {
                        perms = (Set)msgPerm.getValue();
                        for (Object messagingPermission : perms) {
                            writer.println("M|" + (String)msgPerm.getKey() + PermissionHandler.SEPARATOR + ((MessagingPermission)messagingPermission).getTopic() + PermissionHandler.SEPARATOR + ((MessagingPermission)messagingPermission).getAccessLevel());
                        }
                    }
                    for (Map.Entry comPerm : PermissionHandler.this.communicationPermissions.entrySet()) {
                        perms = (Set)comPerm.getValue();
                        for (Object messagingPermission : perms) {
                            writer.println("C|" + (String)comPerm.getKey() + PermissionHandler.SEPARATOR + ((CommunicationPermission)messagingPermission).getServicePid());
                        }
                    }
                    writer.flush();
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File permissionFile = this.getPermissionFile();
        if (permissionFile.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(permissionFile));
                String line = "";
                while ((line = br.readLine()) != null) {
                    String bundleName;
                    String[] args = line.split(Pattern.quote(SEPARATOR));
                    if (args[0].equalsIgnoreCase(U_ID)) {
                        String user = args[1];
                        String pass = args[2];
                        this.users.put(new UserDTO().setName(user), pass);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase(M_ID)) {
                        bundleName = args[1];
                        String topic = args[2];
                        String mode = args[3];
                        Set<MessagingPermission> permissionList = this.messagingPermissions.get(bundleName);
                        if (permissionList == null) {
                            permissionList = new HashSet<MessagingPermission>();
                        }
                        permissionList.add(new MessagingPermission().setTopic(topic).setAccess(Integer.valueOf(mode)));
                        this.messagingPermissions.put(bundleName, permissionList);
                        continue;
                    }
                    if (!args[0].equalsIgnoreCase(C_ID)) continue;
                    bundleName = args[1];
                    String servicePid = args[2];
                    Set<CommunicationPermission> permissionList = this.communicationPermissions.get(bundleName);
                    if (permissionList == null) {
                        permissionList = new HashSet<CommunicationPermission>();
                    }
                    permissionList.add(new CommunicationPermission().setServicePid(servicePid));
                    this.communicationPermissions.put(bundleName, permissionList);
                }
            }
            catch (IOException | NumberFormatException e) {
                Activator.getLog().log(1, "error in permissions file permissions.txt, unable to restore data", (Throwable)e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            this.users.put(new UserDTO().setName("admin"), "admin");
        }
    }

    private File getPermissionFile() {
        File file = new File(PERMISSIONS_FILE);
        if (!file.isFile()) {
            Activator.getLog().log(2, "Permission file is not a file");
        }
        if (!file.exists()) {
            Activator.getLog().log(4, "Permission file does not exist yet");
        }
        return file;
    }
}

