/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.auth.impl.ws;

import com.starbase.core.auth.impl.permission.BundlePermissionContainer;
import com.starbase.core.auth.impl.permission.CommunicationPermission;
import com.starbase.core.auth.impl.permission.MessagingPermission;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.webserver.api.JSONServiceGET;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;

public class AccessViolationWS
implements JSONServiceGET,
MappingServiceAware {
    private Hashtable<String, Set<MessagingPermission>> messagingViolations = new Hashtable();
    private Hashtable<String, Set<CommunicationPermission>> serviceViolations = new Hashtable();
    private MappingService mappingService;
    public static AccessViolationWS instance;

    private AccessViolationWS() {
    }

    public static AccessViolationWS getInstance() {
        if (instance == null) {
            instance = new AccessViolationWS();
        }
        return instance;
    }

    public Object get(Map<String, String> params, String uri) throws Exception {
        Set<String> msgKeys = this.messagingViolations.keySet();
        Set<String> svcKeys = this.serviceViolations.keySet();
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(msgKeys);
        allKeys.addAll(svcKeys);
        Hashtable<String, BundlePermissionContainer> ret = new Hashtable<String, BundlePermissionContainer>();
        for (String bundleName : allKeys) {
            BundlePermissionContainer container = new BundlePermissionContainer();
            container.communicationPermissions = this.serviceViolations.get(bundleName);
            container.messagingPermissions = this.messagingViolations.get(bundleName);
            ret.put(bundleName, container);
        }
        return this.mappingService.mapToString(ret);
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }

    public void add(Bundle bundle, String topic, int accessLevel) {
        Set<MessagingPermission> list = this.messagingViolations.get(bundle.getSymbolicName());
        if (list == null) {
            list = new HashSet<MessagingPermission>();
        }
        list.add(new MessagingPermission().setAccess(accessLevel).setTopic(topic));
        this.messagingViolations.put(bundle.getSymbolicName(), list);
    }

    public void add(Bundle bundle, String servicePid) {
        Set<CommunicationPermission> list = this.serviceViolations.get(bundle.getSymbolicName());
        if (list == null) {
            list = new HashSet<CommunicationPermission>();
        }
        list.add(new CommunicationPermission().setServicePid(servicePid));
        this.serviceViolations.put(bundle.getSymbolicName(), list);
    }

    public void remove(Bundle bundle, String topic, int accessLevel) {
        Set<MessagingPermission> list = this.messagingViolations.get(bundle.getSymbolicName());
        if (list == null) {
            return;
        }
        list.remove(new MessagingPermission().setAccess(accessLevel).setTopic(topic));
    }

    public void remove(Bundle bundle, String servicePid) {
        Set<CommunicationPermission> list = this.serviceViolations.get(bundle.getSymbolicName());
        if (list == null) {
            return;
        }
        list.remove(new CommunicationPermission().setServicePid(servicePid));
    }
}

