/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.auth.impl.ws;

import com.starbase.core.auth.impl.permission.BundlePermissionContainer;
import com.starbase.core.auth.impl.permission.CommunicationPermission;
import com.starbase.core.auth.impl.permission.MessagingPermission;
import com.starbase.core.auth.impl.permission.PermissionHandler;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.webserver.api.JSONServiceGET;
import com.starbase.core.webserver.api.JSONServicePOST;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PermissionWebService
implements JSONServicePOST<String>,
JSONServiceGET,
MappingServiceAware {
    private MappingService mappingService;

    public Object get(Map<String, String> params, String uri) throws Exception {
        String symbolicName = uri;
        BundlePermissionContainer container = new BundlePermissionContainer();
        container.communicationPermissions = PermissionHandler.getInstance().getCommunicationPermissions().get(symbolicName);
        container.messagingPermissions = PermissionHandler.getInstance().getMessagingPermissions().get(symbolicName);
        return this.mappingService.mapToString((Object)container);
    }

    public Class<String> getType() {
        return String.class;
    }

    public String post(Object object, Map<String, String> params, String uri) throws Exception {
        String name = uri;
        BundlePermissionContainer container = (BundlePermissionContainer)this.mappingService.mapToObject(object.toString(), BundlePermissionContainer.class);
        Set<CommunicationPermission> commPerms = PermissionHandler.getInstance().getCommunicationPermissions().get(name);
        Set<MessagingPermission> messPerms = PermissionHandler.getInstance().getMessagingPermissions().get(name);
        if (commPerms == null) {
            commPerms = new HashSet<CommunicationPermission>();
            PermissionHandler.getInstance().getCommunicationPermissions().put(name, commPerms);
        }
        commPerms.clear();
        if (container.communicationPermissions != null) {
            commPerms.addAll(container.communicationPermissions);
        }
        if (messPerms == null) {
            messPerms = new HashSet<MessagingPermission>();
            PermissionHandler.getInstance().getMessagingPermissions().put(name, messPerms);
        }
        messPerms.clear();
        if (container.messagingPermissions != null) {
            messPerms.addAll(container.messagingPermissions);
        }
        String out = this.mappingService.mapToString((Object)container);
        PermissionHandler.getInstance().save();
        return out;
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }
}

