/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.communication;

import com.starbase.core.communication.AddressServiceAwareTracker;
import com.starbase.core.communication.AddressServiceTracker;
import com.starbase.core.communication.CommunicationServicesAwareTracker;
import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.impl.AddressServiceImpl;
import com.starbase.core.communication.impl.AddressWS;
import com.starbase.core.datastore.api.DataStoreServiceAware;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.webserver.api.HTTPService;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private CommunicationServicesAwareTracker communicationServicesAwareTracker;
    private AddressServiceTracker addressServiceTracker;
    private AddressServiceAwareTracker awareTracker;
    private static LogServiceTracker logServiceTracker;

    public static LogService getLog() {
        return logServiceTracker.getService();
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        AddressServiceImpl addressService = new AddressServiceImpl();
        this.awareTracker = new AddressServiceAwareTracker(context, addressService);
        this.awareTracker.open();
        this.addressServiceTracker = new AddressServiceTracker(context, this.awareTracker);
        this.addressServiceTracker.open();
        this.communicationServicesAwareTracker = new CommunicationServicesAwareTracker(context);
        this.communicationServicesAwareTracker.open();
        context.registerService(AddressService.class, (Object)addressService, null);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("ds_type", "persistent");
        context.registerService(DataStoreServiceAware.class, (Object)addressService, properties);
        AddressWS addressWS = new AddressWS();
        ((Dictionary)properties).put("path", "/starbase/address");
        ((Dictionary)properties).put("auth", "true");
        context.registerService(new String[]{MappingServiceAware.class.getName(), HTTPService.class.getName()}, (Object)addressWS, properties);
        addressWS.setAddressService(addressService);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.communicationServicesAwareTracker.close();
        logServiceTracker.close();
        this.addressServiceTracker.close();
        this.awareTracker.close();
        context = null;
    }
}

