/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.communication;

import com.starbase.core.communication.Activator;
import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.api.AddressServiceAware;
import java.util.ArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class AddressServiceAwareTracker
extends ServiceTracker<AddressServiceAware, AddressServiceAware> {
    private AddressService addressService;
    private ArrayList<AddressServiceAware> awareList;

    public AddressServiceAwareTracker(BundleContext context, AddressService addressService) {
        super(context, AddressServiceAware.class, null);
        this.addressService = addressService;
        this.awareList = new ArrayList();
    }

    public void updateAll(AddressService addressService) {
        this.addressService = addressService;
        for (AddressServiceAware addressServiceAware : this.awareList) {
            addressServiceAware.setAddressService(addressService);
        }
    }

    public AddressServiceAware addingService(ServiceReference<AddressServiceAware> reference) {
        Activator.getLog().log(4, "new addresserviceaware object");
        AddressServiceAware sv = (AddressServiceAware)super.addingService(reference);
        this.awareList.add(sv);
        sv.setAddressService(this.addressService);
        return sv;
    }

    public void modifiedService(ServiceReference<AddressServiceAware> reference, AddressServiceAware service) {
        super.modifiedService(reference, (Object)service);
        service.setAddressService(this.addressService);
    }

    public void removedService(ServiceReference<AddressServiceAware> reference, AddressServiceAware service) {
        this.awareList.remove(service);
        super.removedService(reference, (Object)service);
    }
}

