/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.communication;

import com.starbase.core.auth.api.ModuleAuthorizationService;
import com.starbase.core.communication.Activator;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.api.CommunicationServicesAware;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CommunicationServicesAwareTracker
extends ServiceTracker<CommunicationServicesAware, CommunicationServicesAware> {
    private ServiceTracker<CommunicationService, CommunicationService> communicationServicesTracker;
    private ModuleAuthorizationService moduleAuthorizationService;
    private ServiceTracker<ModuleAuthorizationService, ModuleAuthorizationService> modAuthTracker;
    private Map<ServiceReference<CommunicationService>, CommunicationService> recentlyModifiedOrAdded = new HashMap<ServiceReference<CommunicationService>, CommunicationService>();

    public CommunicationServicesAwareTracker(BundleContext context) {
        super(context, CommunicationServicesAware.class, null);
        this.communicationServicesTracker = new ServiceTracker<CommunicationService, CommunicationService>(context, CommunicationService.class, null){

            public CommunicationService addingService(ServiceReference<CommunicationService> reference) {
                CommunicationService sv = (CommunicationService)super.addingService(reference);
                CommunicationServicesAwareTracker.this.recentlyModifiedOrAdded.put(reference, sv);
                CommunicationServicesAwareTracker.this.updateAll();
                return sv;
            }

            public void modifiedService(ServiceReference<CommunicationService> reference, CommunicationService service) {
                CommunicationServicesAwareTracker.this.recentlyModifiedOrAdded.put(reference, service);
                super.modifiedService(reference, (Object)service);
                CommunicationServicesAwareTracker.this.updateAll();
            }

            public void removedService(ServiceReference<CommunicationService> reference, CommunicationService service) {
                super.removedService(reference, (Object)service);
                CommunicationServicesAwareTracker.this.updateAll();
            }
        };
        this.modAuthTracker = new ServiceTracker<ModuleAuthorizationService, ModuleAuthorizationService>(context, ModuleAuthorizationService.class, null){

            public ModuleAuthorizationService addingService(ServiceReference<ModuleAuthorizationService> reference) {
                ModuleAuthorizationService service = (ModuleAuthorizationService)super.addingService(reference);
                CommunicationServicesAwareTracker.this.moduleAuthorizationService = service;
                CommunicationServicesAwareTracker.this.updateAll();
                return service;
            }

            public void modifiedService(ServiceReference<ModuleAuthorizationService> reference, ModuleAuthorizationService service) {
                super.modifiedService(reference, (Object)service);
                CommunicationServicesAwareTracker.this.moduleAuthorizationService = service;
                CommunicationServicesAwareTracker.this.updateAll();
            }

            public void removedService(ServiceReference<ModuleAuthorizationService> reference, ModuleAuthorizationService service) {
                super.removedService(reference, (Object)service);
                CommunicationServicesAwareTracker.this.moduleAuthorizationService = null;
            }
        };
        this.modAuthTracker.open();
        this.communicationServicesTracker.open();
    }

    public CommunicationServicesAware addingService(ServiceReference<CommunicationServicesAware> reference) {
        CommunicationServicesAware sv = (CommunicationServicesAware)super.addingService(reference);
        this.injectCommunicationServices(reference, sv);
        return sv;
    }

    public void modifiedService(ServiceReference<CommunicationServicesAware> reference, CommunicationServicesAware service) {
        super.modifiedService(reference, (Object)service);
        this.injectCommunicationServices(reference, service);
    }

    public void removedService(ServiceReference<CommunicationServicesAware> reference, CommunicationServicesAware service) {
        super.removedService(reference, (Object)service);
    }

    protected void updateAll() {
        Set services = this.getTracked().entrySet();
        for (Map.Entry entry : services) {
            this.injectCommunicationServices((ServiceReference<CommunicationServicesAware>)((ServiceReference)entry.getKey()), (CommunicationServicesAware)entry.getValue());
        }
        this.recentlyModifiedOrAdded.clear();
    }

    private void injectCommunicationServices(ServiceReference<CommunicationServicesAware> srAware, CommunicationServicesAware svAware) {
        String servicePid;
        String[] requestedServices = (String[])srAware.getProperty("services");
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set services = this.communicationServicesTracker.getTracked().entrySet();
        Bundle bundleAware = srAware.getBundle();
        for (Map.Entry entry : services) {
            servicePid = ((ServiceReference)entry.getKey()).getProperty("service.pid").toString();
            if (!this.isRequested(servicePid, requestedServices) || !this.isAllowed(bundleAware, servicePid)) continue;
            map.put(servicePid, entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.recentlyModifiedOrAdded.entrySet()) {
            servicePid = ((ServiceReference)entry.getKey()).getProperty("service.pid").toString();
            if (!this.isRequested(servicePid, requestedServices) || !this.isAllowed(bundleAware, servicePid)) continue;
            map.put(servicePid, entry.getValue());
        }
        svAware.setCommunicationService(map);
    }

    private boolean isRequested(String servicePid, String[] requestedServices) {
        if (requestedServices == null) {
            return true;
        }
        return Arrays.asList(requestedServices).contains(servicePid);
    }

    private boolean isAllowed(Bundle bundle, String servicePid) {
        if (this.moduleAuthorizationService == null) {
            Activator.getLog().log(2, "ModuleAuthorizationService is null, denying all access");
            return false;
        }
        return this.moduleAuthorizationService.authorizeCommunicationService(bundle, servicePid);
    }
}

