/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.communication.impl;

import com.starbase.core.communication.Activator;
import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.communication.impl.AddressStore;
import com.starbase.core.datastore.api.DataStoreService;
import com.starbase.core.datastore.api.DataStoreServiceAware;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AddressServiceImpl
implements AddressService,
DataStoreServiceAware {
    private AddressStore addressTable = new AddressStore();
    private DataStoreService dataStoreService;

    public AddressServiceImpl() {
        Activator.getLog().log(4, "created service " + this.getClass().getSimpleName());
    }

    public String addAddress(String identifier, AddressDTO address) {
        int i = 0;
        while (this.addressTable.containsKey(identifier)) {
            identifier = identifier + "" + ++i;
        }
        this.addressTable.put(identifier, address);
        address.setIdentifier(identifier);
        this.persist();
        return identifier;
    }

    public boolean removeAddress(String identifier) {
        this.addressTable.remove(identifier);
        this.persist();
        return false;
    }

    public String updateAddress(String identifier, AddressDTO address) {
        if (this.addressTable.containsKey(identifier)) {
            AddressDTO temp = (AddressDTO)this.addressTable.get(identifier);
            temp.setTech(address.getTech());
            temp.setTo(address.getTo());
            this.persist();
        } else {
            this.addAddress(identifier, address);
        }
        return identifier;
    }

    public AddressDTO getAddress(String identifier) {
        if (!this.addressTable.containsKey(identifier)) {
            Activator.getLog().log(2, "AddressObject " + identifier + " could not be found!");
        }
        return (AddressDTO)this.addressTable.get(identifier);
    }

    public Map<String, AddressDTO> getAddressList(String filter) {
        if (filter.equals("") || filter.equals("*")) {
            return this.addressTable;
        }
        HashMap<String, AddressDTO> map = new HashMap<String, AddressDTO>();
        Set keys = this.addressTable.keySet();
        for (String key : keys) {
            if (!key.matches(filter)) continue;
            map.put(key, (AddressDTO)this.addressTable.get(key));
        }
        return map;
    }

    public void setDataStoreService(DataStoreService dataStoreService) {
        Activator.getLog().log(3, "injected DSS " + dataStoreService.getClass().getSimpleName());
        this.dataStoreService = dataStoreService;
        this.restore();
    }

    private void restore() {
        if (this.dataStoreService != null) {
            List oldStoreList = null;
            try {
                oldStoreList = this.dataStoreService.get("addressTable", AddressStore.class);
            }
            catch (FileNotFoundException e) {
                Activator.getLog().log(3, "Store of Address Management addressTable.json file not found. Normal on first start of if there are no Address Objects");
            }
            catch (Exception e) {
                Activator.getLog().log(3, "failed to restore addresses", (Throwable)e);
            }
            if (oldStoreList != null && !oldStoreList.isEmpty()) {
                AddressStore oldStore = (AddressStore)oldStoreList.get(0);
                oldStore.putAll(this.addressTable);
                this.addressTable = oldStore;
            }
        }
    }

    private void persist() {
        if (this.dataStoreService != null) {
            if (this.addressTable == null) {
                Activator.getLog().log(3, "address table is null");
                return;
            }
            if (this.addressTable.isEmpty()) {
                Activator.getLog().log(3, "address table is empty");
                return;
            }
            try {
                this.dataStoreService.store("addressTable", (Object)this.addressTable, AddressStore.class);
            }
            catch (Exception e) {
                Activator.getLog().log(1, "failed to store addresses", (Throwable)e);
            }
        }
    }

    public Map<String, AddressDTO> getAddressListByTechnology(String tech) {
        HashMap<String, AddressDTO> map = new HashMap<String, AddressDTO>();
        for (Map.Entry entry : this.addressTable.entrySet()) {
            if (!((AddressDTO)entry.getValue()).getTech().equals(tech)) continue;
            map.put((String)entry.getKey(), (AddressDTO)entry.getValue());
        }
        return map;
    }
}

