/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.communication.impl;

import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.exception.general.BadRequestException;
import com.starbase.core.exception.general.NotFoundException;
import com.starbase.core.exception.general.ServiceMissingException;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.webserver.api.JSONServiceDELETE;
import com.starbase.core.webserver.api.JSONServiceGET;
import com.starbase.core.webserver.api.JSONServicePOST;
import java.util.Map;

public class AddressWS
implements JSONServiceGET,
JSONServicePOST<String>,
JSONServiceDELETE,
MappingServiceAware,
AddressServiceAware {
    private MappingService mappingService;
    private AddressService addressService;

    public Object get(Map<String, String> params, String uri) throws Exception {
        if (this.mappingService == null) {
            throw new ServiceMissingException("mapping service is missing");
        }
        if (this.addressService == null) {
            throw new ServiceMissingException("address service is missing");
        }
        String identifier = this.getIdentifier(uri);
        if (identifier.equals("")) {
            return this.mappingService.mapToString((Object)this.addressService.getAddressList(""));
        }
        return this.mappingService.mapToString((Object)this.addressService.getAddress(identifier));
    }

    private String getIdentifier(String uri) {
        String addParam = uri;
        addParam = addParam.replace("/", "");
        return addParam;
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }

    public void setAddressService(AddressService addressService) {
        this.addressService = addressService;
    }

    public Class<String> getType() {
        return String.class;
    }

    public String post(Object object, Map<String, String> params, String uri) throws Exception {
        if (this.mappingService == null) {
            throw new ServiceMissingException("mapping service is missing");
        }
        if (this.addressService == null) {
            throw new ServiceMissingException("address service is missing");
        }
        String identifier = this.getIdentifier(uri);
        if (identifier.equals("")) {
            throw new NotFoundException("No identifier key given, cannot store address object");
        }
        String incJSON = object.toString();
        AddressDTO dto = null;
        try {
            dto = (AddressDTO)this.mappingService.mapToObject(incJSON, AddressDTO.class);
        }
        catch (Exception e) {
            throw new BadRequestException("Unable to create object from request");
        }
        if (this.addressService.getAddress(identifier) != null) {
            this.addressService.removeAddress(identifier);
        }
        this.addressService.addAddress(identifier, dto);
        return this.mappingService.mapToString((Object)this.addressService.getAddress(identifier));
    }

    public void delete(Map<String, String> params, String uri) throws Exception {
        if (uri.equals("")) {
            throw new NotFoundException("No identifier key given, cannot delete address object");
        }
        if (this.addressService.getAddress(uri) == null) {
            throw new NotFoundException("Given identifier (" + uri + ") not found, cannot delete address object");
        }
        this.addressService.removeAddress(uri);
    }
}

