/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.config;

import com.starbase.core.config.Activator;
import com.starbase.core.config.api.ConfiguredService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class ConfiguredServiceTracker
extends ServiceTracker<ConfiguredService, ConfiguredService> {
    private ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> configAdminTracker;

    public ConfiguredServiceTracker(BundleContext context) {
        super(context, ConfiguredService.class, null);
        this.configAdminTracker = new ServiceTracker<ConfigurationAdmin, ConfigurationAdmin>(context, ConfigurationAdmin.class, null){

            public ConfigurationAdmin addingService(ServiceReference<ConfigurationAdmin> reference) {
                ConfigurationAdmin sv = (ConfigurationAdmin)super.addingService(reference);
                ConfiguredServiceTracker.this.updateCurrent();
                return sv;
            }

            public void modifiedService(ServiceReference<ConfigurationAdmin> reference, ConfigurationAdmin service) {
                ConfiguredServiceTracker.this.updateCurrent();
                super.modifiedService(reference, (Object)service);
            }
        };
        this.configAdminTracker.open();
    }

    protected void finalize() throws Throwable {
        this.configAdminTracker.close();
    }

    public ConfiguredService addingService(ServiceReference<ConfiguredService> reference) {
        ConfiguredService sv = (ConfiguredService)super.addingService(reference);
        this.updateConfig(reference, sv);
        return sv;
    }

    public void modifiedService(ServiceReference<ConfiguredService> reference, ConfiguredService service) {
        super.modifiedService(reference, (Object)service);
        this.updateConfig(reference, service);
    }

    protected void updateCurrent() {
        ServiceReference[] services = this.getServiceReferences();
        if (services != null) {
            for (ServiceReference serviceReference : services) {
                this.updateConfig((ServiceReference<ConfiguredService>)serviceReference, (ConfiguredService)this.getService(serviceReference));
            }
        }
    }

    private void updateConfig(ServiceReference<ConfiguredService> reference, ConfiguredService sv) {
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.configAdminTracker.getService();
        if (configurationAdmin == null) {
            Activator.getLog().log(1, "ConfigurationAdminService not found!");
            return;
        }
        String pid = null;
        if (reference.getProperty("service.pid") != null) {
            pid = reference.getProperty("service.pid").toString();
        }
        try {
            Configuration config = configurationAdmin.getConfiguration(pid, "?");
            if (config.getProperties() != null) {
                return;
            }
            config.update(sv.getDefaultConfiguration());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

