/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.config.impl;

import com.starbase.core.config.Activator;
import com.starbase.core.exception.general.BadRequestException;
import com.starbase.core.exception.general.NotFoundException;
import com.starbase.core.exception.general.ServiceMissingException;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.webserver.api.JSONServiceGET;
import com.starbase.core.webserver.api.JSONServicePOST;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationWS
implements JSONServiceGET,
JSONServicePOST<String>,
MappingServiceAware {
    private static final String LOCATION = "?";
    private MappingService mappingService;

    public Object get(Map<String, String> params, String uri) throws Exception {
        if (this.mappingService == null) {
            throw new ServiceMissingException("mapping service is missing");
        }
        String pid = uri;
        pid = pid.replaceFirst("/", "");
        ConfigurationAdmin configurationAdmin = this.getConfigurationAdmin();
        if (pid.equals("")) {
            try {
                Configuration[] config = configurationAdmin.listConfigurations(null);
                ArrayList<String> pids = new ArrayList<String>();
                if (config != null) {
                    for (Configuration configuration : config) {
                        pids.add(configuration.getPid());
                    }
                }
                return this.mappingService.mapToString(pids);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        Configuration config = configurationAdmin.getConfiguration(pid, LOCATION);
        Dictionary props = config.getProperties();
        if (props == null || props.isEmpty()) {
            throw new NotFoundException("No configuration for given service PID (" + pid + ")");
        }
        return this.mappingService.mapToString(this.dictionaryToHashtable(props));
    }

    private Hashtable<String, String> dictionaryToHashtable(Dictionary<String, Object> props) {
        Enumeration<String> propsIterator = props.keys();
        Hashtable<String, String> ht = new Hashtable<String, String>();
        while (propsIterator.hasMoreElements()) {
            String key = propsIterator.nextElement();
            String content = props.get(key).toString();
            ht.put(key, content);
        }
        return ht;
    }

    public String post(Object object, Map<String, String> params, String uri) throws Exception {
        if (this.mappingService == null) {
            throw new ServiceMissingException("mapping service is missing");
        }
        String pid = uri;
        pid = pid.replaceFirst("/", "");
        String incData = object.toString();
        if (pid.equals("")) {
            throw new BadRequestException("No PID given");
        }
        ConfigurationAdmin configurationAdmin = this.getConfigurationAdmin();
        Configuration config = configurationAdmin.getConfiguration(pid, LOCATION);
        Hashtable<String, Object> props = config.getProperties();
        if (props == null) {
            Activator.getLog().log(2, "No configuration for given service PID (" + pid + ")");
            props = new Hashtable();
        }
        try {
            Hashtable ht = (Hashtable)this.mappingService.mapToObject(incData, Hashtable.class);
            if (ht.get("service.pid") != null) {
                props = new Hashtable<String, Object>();
            }
            Set keys = ht.keySet();
            for (String key : keys) {
                ((Dictionary)props).put(key, ht.get(key));
            }
        }
        catch (IOException e) {
            Activator.getLog().log(2, "error reading incoming json structure", (Throwable)e);
        }
        config.update((Dictionary)props);
        return this.mappingService.mapToString(this.dictionaryToHashtable(props));
    }

    private ConfigurationAdmin getConfigurationAdmin() throws Exception {
        ServiceReference sr = Activator.getContext().getServiceReference(ConfigurationAdmin.class);
        if (sr == null) {
            throw new ServiceMissingException("ConfigurationAdmin is not available");
        }
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)Activator.getContext().getService(sr);
        if (configurationAdmin == null) {
            throw new ServiceMissingException("ConfigurationAdmin is not available");
        }
        return configurationAdmin;
    }

    public Class<String> getType() {
        return String.class;
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }
}

