/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto;

import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationServicesAware;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.CryptoServiceAwareTracker;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.crypto.impl.CryptoManager;
import com.starbase.core.crypto.keys.KeyStorage;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingServiceAware;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;
    public static final String RESPONSE_DELIMITER = ":";
    public static final String STORAGE_KEY_DELIMITER = "~";
    public static final String AUTOMODE = "AUTOMODE";
    private static String DEVICE_ID;
    private CryptoServiceAwareTracker cryptoServiceAwareTracker;

    public static String getDEVICE_ID() {
        return DEVICE_ID;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static LogService getLog() {
        return logServiceTracker.getService();
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        CryptoManager cryptoServiceManager = new CryptoManager();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("topic", this.generateMessagingTopics());
        ((Dictionary)properties).put("service.pid", "com.starbase.core.crypto");
        context.registerService(new String[]{AddressServiceAware.class.getName(), MessageConsumer.class.getName(), CommunicationServicesAware.class.getName(), MessagingServiceAware.class.getName(), ConfiguredService.class.getName(), ManagedService.class.getName()}, (Object)cryptoServiceManager, properties);
        this.cryptoServiceAwareTracker = new CryptoServiceAwareTracker(cryptoServiceManager);
        this.cryptoServiceAwareTracker.open();
        KeyStorage.init();
        Activator.getLog().log(3, context.getBundle().getSymbolicName() + " startet. Crypto service registered.");
        DEVICE_ID = context.getProperty("com.starbase.id");
        if (DEVICE_ID == null) {
            Activator.getLog().log(2, "No device ID found in the config file.");
        } else if (DEVICE_ID.equals("00000000")) {
            Activator.getLog().log(2, "\n======================================================================================\nHINT: YOUR SYSTEM IS NOT SECURE. YOU ARE PROBABLY USING THE DEFAULT STARBASE KEYSTORE!\n======================================================================================");
        }
    }

    public String[] generateMessagingTopics() {
        String[] topics = new String[CipherMode.getModes().size() + 1];
        int i = 0;
        for (String mode : CipherMode.getModes()) {
            if (mode.equals(CipherMode.PLAIN)) continue;
            topics[i++] = mode.toLowerCase() + ".in.*";
        }
        topics[i] = "out.crypto.*";
        return topics;
    }

    public void stop(BundleContext context) throws Exception {
        KeyStorage.backup();
        this.cryptoServiceAwareTracker.close();
        Activator.getLog().log(3, context.getBundle().getSymbolicName() + " stopped.");
        logServiceTracker.close();
        Activator.context = null;
    }
}

