/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto;

import com.starbase.core.crypto.Activator;
import com.starbase.core.crypto.api.CryptoService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.crypto.impl.CryptoManager;
import com.starbase.core.crypto.impl.CryptoServiceProxy;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CryptoServiceAwareTracker
extends ServiceTracker<CryptoServiceAware, CryptoServiceAware> {
    private CryptoManager cryptoManager;
    private Map<Bundle, CryptoService> cryptoServiceProxyCache = new HashMap<Bundle, CryptoService>();

    public CryptoServiceAwareTracker(CryptoManager cryptoServiceManager) {
        super(Activator.getContext(), CryptoServiceAware.class, null);
        this.cryptoManager = cryptoServiceManager;
    }

    public CryptoServiceAware addingService(ServiceReference<CryptoServiceAware> reference) {
        CryptoServiceAware sv = (CryptoServiceAware)super.addingService(reference);
        this.putCryptoService(sv, reference.getBundle());
        return sv;
    }

    public void modifiedService(ServiceReference<CryptoServiceAware> reference, CryptoServiceAware service) {
        super.modifiedService(reference, (Object)service);
        this.putCryptoService(service, reference.getBundle());
    }

    private void putCryptoService(CryptoServiceAware service, Bundle bundle) {
        if (this.cryptoServiceProxyCache.containsKey(bundle)) {
            CryptoService cryptoServiceProxy = this.cryptoServiceProxyCache.get(bundle);
            service.setCryptoService(cryptoServiceProxy);
        } else {
            CryptoServiceProxy cryptoServiceProxy = new CryptoServiceProxy(this.cryptoManager, bundle);
            this.cryptoServiceProxyCache.put(bundle, cryptoServiceProxy);
            service.setCryptoService((CryptoService)cryptoServiceProxy);
        }
    }
}

