/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto.algorithms.aes;

import com.starbase.core.crypto.Activator;
import com.starbase.core.crypto.algorithms.aes.BouncyCastle_AES;
import com.starbase.core.crypto.algorithms.aes.BouncyCastle_AES_CCM;
import com.starbase.core.crypto.algorithms.aes.BouncyCastle_AES_GCM;
import com.starbase.core.crypto.algorithms.aes.SecureRandomGenerator;
import com.starbase.core.crypto.api.CipherMode;
import java.util.Base64;

public class AESProvider {
    public static BouncyCastle_AES getCryptoInstance(CipherMode cipherMode) {
        switch (cipherMode) {
            case AES128_GCM: {
                return new BouncyCastle_AES_GCM(CipherMode.AES128_GCM);
            }
            case AES192_GCM: {
                return new BouncyCastle_AES_GCM(CipherMode.AES192_GCM);
            }
            case AES256_GCM: {
                return new BouncyCastle_AES_GCM(CipherMode.AES256_GCM);
            }
            case AES128_CCM: {
                return new BouncyCastle_AES_CCM(CipherMode.AES128_CCM);
            }
            case AES192_CCM: {
                return new BouncyCastle_AES_CCM(CipherMode.AES192_CCM);
            }
            case AES256_CCM: {
                return new BouncyCastle_AES_CCM(CipherMode.AES256_CCM);
            }
            case AES128_CBC: {
                return new BouncyCastle_AES_CCM(CipherMode.AES128_CBC);
            }
            case AES192_CBC: {
                return new BouncyCastle_AES_CCM(CipherMode.AES192_CBC);
            }
            case AES256_CBC: {
                return new BouncyCastle_AES_CCM(CipherMode.AES256_CBC);
            }
        }
        Activator.getLog().log(1, "Invalid CipherMode.");
        return null;
    }

    public static byte[] generateKey(CipherMode cipherMode) {
        byte[] key = null;
        switch (cipherMode) {
            case AES128_GCM: 
            case AES128_CCM: 
            case AES128_CBC: {
                key = SecureRandomGenerator.returnKey(16);
                break;
            }
            case AES192_GCM: 
            case AES192_CCM: 
            case AES192_CBC: {
                key = SecureRandomGenerator.returnKey(24);
                break;
            }
            case AES256_GCM: 
            case AES256_CCM: 
            case AES256_CBC: {
                key = SecureRandomGenerator.returnKey(32);
                break;
            }
            default: {
                Activator.getLog().log(1, "Invalid CipherMode.");
            }
        }
        return key;
    }

    public static String generateKeyString(CipherMode cipherMode) {
        return Base64.getEncoder().encodeToString(AESProvider.generateKey(cipherMode));
    }
}

