/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto.algorithms.aes;

import com.starbase.core.crypto.Activator;
import com.starbase.core.crypto.algorithms.aes.BouncyCastle_AES;
import com.starbase.core.crypto.algorithms.aes.BytesProcessing;
import com.starbase.core.crypto.algorithms.aes.SecureRandomGenerator;
import com.starbase.core.crypto.api.CipherMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class BouncyCastle_AES_GCM
extends BouncyCastle_AES {
    GCMBlockCipher encryptCipher = null;
    GCMBlockCipher decryptCipher = null;
    byte[] buf = new byte[16];
    byte[] obuf = new byte[512];
    public final int blockSize = 16;

    public BouncyCastle_AES_GCM(CipherMode cipherMode) {
        super(cipherMode);
        this.IV = SecureRandomGenerator.returnKey(16);
    }

    @Override
    public String encrypt(String message) {
        this.initCipherEncrypt();
        byte[] encryptedData = null;
        try {
            encryptedData = this.GCMEncryptBytes(message.getBytes());
        }
        catch (DataLengthException e) {
            Activator.getLog().log(1, "DataLengthException.", (Throwable)e);
        }
        catch (ShortBufferException e) {
            Activator.getLog().log(1, "ShortBufferException.", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            Activator.getLog().log(1, "IllegalBlockSizeException.", (Throwable)e);
        }
        catch (BadPaddingException e) {
            Activator.getLog().log(1, "BadPaddingException.", (Throwable)e);
        }
        catch (IllegalStateException e) {
            Activator.getLog().log(1, "IllegalStateException.", (Throwable)e);
        }
        catch (InvalidCipherTextException e) {
            Activator.getLog().log(1, "InvalidCipherTextException.", (Throwable)e);
        }
        catch (IOException e) {
            Activator.getLog().log(1, "IOException.", (Throwable)e);
        }
        this.resetCiphers();
        return Base64.getEncoder().encodeToString(encryptedData);
    }

    @Override
    public String decrypt(String encryptedString) {
        byte[] encryptedData = Base64.getDecoder().decode(encryptedString);
        byte[] decryptedData = null;
        this.initCipherDecrypt(encryptedData);
        try {
            decryptedData = this.GCMDecryptBytes(encryptedData);
        }
        catch (DataLengthException e) {
            Activator.getLog().log(1, "DataLengthException.", (Throwable)e);
            e.printStackTrace();
        }
        catch (ShortBufferException e) {
            Activator.getLog().log(1, "ShortBufferException.", (Throwable)e);
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            Activator.getLog().log(1, "IllegalBlockSizeException.", (Throwable)e);
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            Activator.getLog().log(1, "BadPaddingException.", (Throwable)e);
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            Activator.getLog().log(1, "IllegalStateException.", (Throwable)e);
            e.printStackTrace();
        }
        catch (InvalidCipherTextException e) {
            Activator.getLog().log(1, "InvalidCipherTextException.", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            Activator.getLog().log(1, "IOException.", (Throwable)e);
            e.printStackTrace();
        }
        this.resetCiphers();
        return new String(decryptedData);
    }

    private void initCipherEncrypt() throws IllegalArgumentException {
        this.encryptCipher = new GCMBlockCipher((BlockCipher)new AESEngine());
        ParametersWithIV parameterIV = new ParametersWithIV((CipherParameters)new KeyParameter(this.key), this.IV);
        this.encryptCipher.init(true, (CipherParameters)parameterIV);
    }

    private void initCipherDecrypt(byte[] ciphertext) throws IllegalArgumentException {
        this.decryptCipher = new GCMBlockCipher((BlockCipher)new AESEngine());
        byte[] IV = BytesProcessing.getIV(ciphertext, 16);
        ParametersWithIV parameterIV = new ParametersWithIV((CipherParameters)new KeyParameter(this.key), IV);
        this.decryptCipher.init(false, (CipherParameters)parameterIV);
    }

    private void resetCiphers() {
        if (this.encryptCipher != null) {
            this.encryptCipher.reset();
        }
        if (this.decryptCipher != null) {
            this.decryptCipher.reset();
        }
    }

    private void GCMEncrypt(InputStream in, OutputStream out) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException, DataLengthException, IllegalStateException, InvalidCipherTextException, IOException {
        int noBytesRead = 0;
        int noBytesProcessed = 0;
        while ((noBytesRead = in.read(this.buf)) >= 0) {
            noBytesProcessed = this.encryptCipher.processBytes(this.buf, 0, noBytesRead, this.obuf, 0);
            out.write(this.obuf, 0, noBytesProcessed);
        }
        noBytesProcessed = this.encryptCipher.doFinal(this.obuf, 0);
        out.write(this.obuf, 0, noBytesProcessed);
        out.flush();
        in.close();
        out.close();
    }

    private byte[] GCMEncryptBytes(byte[] inputbytes) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException, DataLengthException, IllegalStateException, InvalidCipherTextException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(inputbytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.GCMEncrypt(in, out);
        byte[] encryptedBytes = BytesProcessing.getBytesFromStream(out);
        encryptedBytes = BytesProcessing.addIV(this.IV, encryptedBytes);
        return encryptedBytes;
    }

    private void GCMDecrypt(InputStream in, OutputStream out) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException, DataLengthException, IllegalStateException, InvalidCipherTextException, IOException {
        int noBytesRead = 0;
        int noBytesProcessed = 0;
        while ((noBytesRead = in.read(this.buf)) >= 0) {
            noBytesProcessed = this.decryptCipher.processBytes(this.buf, 0, noBytesRead, this.obuf, 0);
            out.write(this.obuf, 0, noBytesProcessed);
        }
        noBytesProcessed = this.decryptCipher.doFinal(this.obuf, 0);
        out.write(this.obuf, 0, noBytesProcessed);
        out.flush();
        in.close();
        out.close();
    }

    private byte[] GCMDecryptBytes(byte[] inputbytes) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException, DataLengthException, IllegalStateException, InvalidCipherTextException, IOException {
        inputbytes = BytesProcessing.deteleIV(inputbytes, 16);
        ByteArrayInputStream in = new ByteArrayInputStream(inputbytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.GCMDecrypt(in, out);
        byte[] decryptedBytes = BytesProcessing.getBytesFromStream(out);
        return decryptedBytes;
    }
}

