/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto.algorithms.rsa;

import com.starbase.core.crypto.Activator;
import com.starbase.core.crypto.algorithms.rsa.RSAProvider;
import com.starbase.core.crypto.algorithms.rsa.StandardRSAProvider;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Base64;

public abstract class RSAManager {
    private static final String CERT_BEGIN = "-----BEGIN CERTIFICATE-----\n";
    private static final String CERT_END = "\n-----END CERTIFICATE-----";
    private static RSAProvider encryptionProvider;
    private static RSAProvider decryptionProvider;
    private static RSAProvider signingProvider;
    private static RSAProvider verificationProvider;
    private static KeyStore pubCertStore;
    private static String certstore;
    private static String certstorepass;

    public static String encrypt(String message, String alias, String passphrase) {
        return encryptionProvider.encrypt(message, alias, passphrase);
    }

    public static String decrypt(String encryptedString, String alias, String passphrase) {
        return decryptionProvider.decrypt(encryptedString, alias, passphrase);
    }

    public static Certificate getPublicKeyCertificate(String alias) {
        Certificate cert = null;
        if (alias.equals("BouncyCastle")) {
            try {
                cert = pubCertStore.getCertificate("myend2endcert");
            }
            catch (KeyStoreException e) {
                Activator.getLog().log(2, "Loading local certificate with alias " + alias + " failed.");
            }
        } else {
            try {
                cert = pubCertStore.getCertificate(alias);
            }
            catch (KeyStoreException e) {
                Activator.getLog().log(2, "Loading local certificate with alias " + alias + " failed.");
            }
        }
        return cert;
    }

    public static void storePublicKeyCertificate(Certificate cert, String alias) {
        try {
            pubCertStore.setEntry(alias, new KeyStore.TrustedCertificateEntry(cert), null);
            pubCertStore.store(new FileOutputStream(certstore), certstorepass.toCharArray());
            Activator.getLog().log(4, "Storing Certificate for " + alias + " to trusted Certificates.");
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Activator.getLog().log(2, "Responded Certificate from " + alias + " could not be stored in certstore.");
        }
    }

    public static String sign(String message, String alias, String passphrase) {
        String signature = signingProvider.sign(message, alias, passphrase);
        return signature;
    }

    public static boolean verify(String signature, String message, String alias) {
        boolean verification = verificationProvider.verify(signature, message, alias);
        return verification;
    }

    public static void initPublicCertStore(String path, String passphrase, String type) {
        pubCertStore = encryptionProvider.getPubCertStore();
        certstore = path;
        certstorepass = passphrase;
    }

    public static void initDecryptionProvider(String path, String passphrase, String type, String provider) {
        if (provider.equals("BouncyCastle")) {
            decryptionProvider = new StandardRSAProvider(path, passphrase, type);
        }
    }

    public static void initEncryptionProvider(String path, String passphrase, String type, String provider) {
        if (provider.equals("BouncyCastle")) {
            encryptionProvider = new StandardRSAProvider(path, passphrase, type);
        }
    }

    public static void initSigningProvider(String path, String passphrase, String type, String provider) {
        if (provider.equals("BouncyCastle")) {
            signingProvider = new StandardRSAProvider(path, passphrase, type);
        }
    }

    public static void initVerificationProvider(String path, String passphrase, String type, String provider) {
        if (provider.equals("BouncyCastle")) {
            verificationProvider = new StandardRSAProvider(path, passphrase, type);
        }
    }

    public static String convertToPem(Certificate cert) {
        String pemCertPre = null;
        try {
            pemCertPre = Base64.getEncoder().encodeToString(cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            Activator.getLog().log(1, "Certificate base64 encoding failed.");
        }
        String pemCert = CERT_BEGIN + pemCertPre + CERT_END;
        return pemCert;
    }

    public static Certificate getCertFromPem(String pemCert) {
        Certificate cert = null;
        String certString = pemCert.replaceAll(CERT_BEGIN, "").replaceAll(CERT_END, "");
        byte[] decoded = Base64.getDecoder().decode(certString);
        try {
            cert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(decoded));
        }
        catch (CertificateException e) {
            Activator.getLog().log(1, "Generating certificate from decoded pem failed.");
        }
        return cert;
    }

    public static KeyStore loadKeyStore(String path, String passphrase, String type) {
        KeyStore ks = null;
        try {
            char[] keyPassphrase = passphrase.toCharArray();
            ks = KeyStore.getInstance(type);
            ks.load(new FileInputStream(path), keyPassphrase);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Activator.getLog().log(2, "Loading keystore failed.");
        }
        return ks;
    }

    public static String getHexString(byte[] b) throws Exception {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

