/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto.algorithms.rsa;

import com.starbase.core.crypto.Activator;
import com.starbase.core.crypto.algorithms.rsa.RSAManager;
import com.starbase.core.crypto.algorithms.rsa.RSAProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class StandardRSAProvider
extends RSAProvider {
    private KeyStore ks = null;

    protected StandardRSAProvider(String path, String passphrase, String type) {
        try {
            char[] keyPassphrase = passphrase.toCharArray();
            this.ks = KeyStore.getInstance(type);
            this.ks.load(new FileInputStream(path), keyPassphrase);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Activator.getLog().log(2, "Loading keystore failed.");
        }
    }

    private PrivateKey loadPrivateKey(String alias, String passphrase) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (alias == null) {
                alias = "1";
            }
            return (PrivateKey)this.ks.getKey(alias, passphrase.toCharArray());
        }
        catch (Exception e) {
            Activator.getLog().log(1, "Error while loading private key for alias: " + alias + ". Trying to load public key.", (Throwable)e);
            return null;
        }
    }

    private PublicKey loadPublicKey(String alias) {
        Certificate cert = this.getCertificate(alias);
        if (cert == null) {
            return null;
        }
        return cert.getPublicKey();
    }

    private AsymmetricKeyParameter getAsymmetricKeyParameter(String alias, String passphrase) {
        if (passphrase != null) {
            try {
                return PrivateKeyFactory.createKey((byte[])this.loadPrivateKey(alias, passphrase).getEncoded());
            }
            catch (IOException iOException) {
            }
        } else {
            try {
                return PublicKeyFactory.createKey((byte[])this.loadPublicKey(alias).getEncoded());
            }
            catch (IOException e) {
                Activator.getLog().log(1, "Error while loading public key for alias: " + alias + ".", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String encrypt(String message, String alias, String passphrase) {
        AsymmetricKeyParameter keyParam = this.getAsymmetricKeyParameter(alias, passphrase);
        String encryptedData = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            RSAEngine e = new RSAEngine();
            e = new PKCS1Encoding((AsymmetricBlockCipher)e);
            e.init(true, (CipherParameters)keyParam);
            byte[] messageBytes = message.getBytes();
            byte[] hexEncodedCipher = e.processBlock(messageBytes, 0, messageBytes.length);
            encryptedData = RSAManager.getHexString(hexEncodedCipher);
        }
        catch (Exception e) {
            Activator.getLog().log(1, "RSA encryption error", (Throwable)e);
        }
        return encryptedData;
    }

    @Override
    public String decrypt(String encryptedData, String alias, String passphrase) {
        String outputData = null;
        AsymmetricKeyParameter keyParam = this.getAsymmetricKeyParameter(alias, passphrase);
        byte[] messageBytes = RSAManager.hexStringToByteArray(encryptedData);
        try {
            RSAEngine e = new RSAEngine();
            e = new PKCS1Encoding((AsymmetricBlockCipher)e);
            e.init(false, (CipherParameters)keyParam);
            byte[] hexEncodedCipher = e.processBlock(messageBytes, 0, messageBytes.length);
            outputData = new String(hexEncodedCipher);
        }
        catch (Exception e) {
            Activator.getLog().log(3, "Hex RSA decryption failed. Trying to decrypt Base 64.");
            byte[] dectyptedText = null;
            try {
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, this.loadPrivateKey(alias, passphrase));
                dectyptedText = cipher.doFinal(Base64.decodeBase64((byte[])encryptedData.getBytes()));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e1) {
                Activator.getLog().log(1, "RSA decryption error for Base 64 format.");
            }
            outputData = new String(dectyptedText);
        }
        return outputData;
    }

    @Override
    public boolean verify(String signature, String message, String alias) {
        try {
            Signature sig = Signature.getInstance("SHA512withRSA");
            PublicKey pub = this.loadPublicKey(alias);
            sig.initVerify(pub);
            byte[] data = message.getBytes();
            sig.update(data);
            boolean verification = sig.verify(RSAManager.hexStringToByteArray(signature));
            return verification;
        }
        catch (Exception e) {
            Activator.getLog().log(1, "Error while RSA Signature verification", (Throwable)e);
            return false;
        }
    }

    @Override
    public Certificate getCertificate(String alias) {
        if (alias == null) {
            Activator.getLog().log(1, "Certificate Alias must not be null.");
            return null;
        }
        try {
            if (this.ks.containsAlias(alias)) {
                return this.ks.getCertificate(alias);
            }
            Activator.getLog().log(1, "Certificate for alias " + alias + " not available.");
            return null;
        }
        catch (KeyStoreException e) {
            Activator.getLog().log(1, "Loading certificate with alias " + alias + " failed.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String sign(String message, String alias, String passphrase) {
        byte[] signatureBytes = null;
        try {
            byte[] data = message.getBytes("UTF8");
            Signature sig = Signature.getInstance("SHA512withRSA");
            sig.initSign(this.loadPrivateKey(alias, passphrase));
            sig.update(data);
            signatureBytes = sig.sign();
            return RSAManager.getHexString(signatureBytes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public KeyStore getPubCertStore() {
        return this.ks;
    }
}

