/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto.impl;

import com.starbase.core.DTOFactory;
import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.api.CommunicationServicesAware;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.Activator;
import com.starbase.core.crypto.algorithms.aes.AESProvider;
import com.starbase.core.crypto.algorithms.aes.SecureRandomGenerator;
import com.starbase.core.crypto.algorithms.rsa.RSAManager;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.crypto.impl.CryptoServiceProxy;
import com.starbase.core.crypto.keys.KeyStorage;
import com.starbase.core.exception.io.ContentTooLongException;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.core.messaging.dto.EventDTO;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class CryptoManager
implements CommunicationServicesAware,
MessageConsumer,
MessagingServiceAware,
AddressServiceAware,
ManagedService,
ConfiguredService {
    protected static final String KEYSTORE_PATH = "keystore.path";
    protected static final String KEYSTORE_PASSWORD = "keystore.password";
    protected static final String TRUSTEDCERTSTORE_PASSWORD = "trustedcertstore.password";
    protected static final String TRUSTEDCERTSTORE_PATH = "trustedcertstore.path";
    protected static final String E2EKEYSTORE_PATH = "e2ekeystore.path";
    protected static final String PROVIDER = "provider";
    public static final String E2EKEYSTORE_PASSWORD = "e2ekeystore.password";
    public static final String STARBASECERTSTORE_PASSWORD = "starbasecertstore.password";
    public static final String STARBASECERTSTORE_PATH = "starbasecertstore.path";
    protected static final String BUNDLENAME = "[bundlename]";
    private static final String REQUEST = "REQUEST";
    public static final String MYE2ECERT = "myend2endcert";
    public static final String YUBIKEYCERT = "Certificate for Key Management";
    protected Dictionary<String, ?> configProperties;
    private MessagingService messagingService;
    private AddressService addressService;
    private CommunicationService communicationService;
    private Map<String, CommunicationService> serviceArray;
    private HashMap<String, LinkedList<EventDTO>> eventBuffer = new HashMap();
    private HashMap<String, String> challenges = new HashMap();

    public CryptoManager() {
        this.configProperties = this.getDefaultConfiguration();
    }

    private void forwardWithCrypto(EventDTO event, String topic) {
        CryptoServiceProxy prx = new CryptoServiceProxy(this, Activator.getContext().getBundle());
        AddressDTO address = this.addressService.getAddress(event.getTo());
        if (address == null) {
            Activator.getLog().log(2, "unable to send encrypted message, cannot find address " + event.getTo());
            return;
        }
        CipherMode cipherMode = event.getCipherState();
        if (cipherMode.equals((Object)CipherMode.PLAIN)) {
            cipherMode = CipherMode.AES256_GCM;
        }
        prx.sendMessage(address, event, cipherMode, this.communicationService);
    }

    private boolean eventIsValid(EventDTO event) {
        if (this.addressService == null) {
            Activator.getLog().log(1, "AddressService is null.");
            return false;
        }
        AddressDTO address = this.addressService.getAddress(event.getFrom());
        if (address == null) {
            Activator.getLog().log(1, "AddressDTO is null.");
            return false;
        }
        String storageKey = address.getTo();
        if (storageKey == null || storageKey.isEmpty()) {
            Activator.getLog().log(1, "To in AddressDTO is null or empty.");
            return false;
        }
        String tech = address.getTech();
        if (tech == null) {
            Activator.getLog().log(1, "Tech in AddressDTO is null.");
            return false;
        }
        this.communicationService = this.serviceArray.get(tech);
        if (this.communicationService == null) {
            Activator.getLog().log(1, "CommunicationService is null.");
            return false;
        }
        return true;
    }

    private void handleKeyRequest(EventDTO event) {
        Certificate cert = RSAManager.getPublicKeyCertificate(event.getFrom());
        if (cert == null) {
            Activator.getLog().log(4, "No E2E public key certificate available for " + event.getFrom());
            this.makeCertificateRequest(event);
            return;
        }
        Activator.getLog().log(4, "Handling Session Key Request: " + event.getBody());
        Activator.getLog().log(4, "Asking for: " + event.getFrom() + "~" + event.getBody());
        String sessionKey = (String)KeyStorage.getInstance(String.class).get(event.getFrom() + "~" + event.getBody());
        String responseBody = event.getBody() + ":" + sessionKey;
        String encSessionKey = RSAManager.encrypt(responseBody, event.getFrom(), null);
        AddressDTO address = this.addressService.getAddress(event.getFrom());
        this.communicationService.sendMessage(address, DTOFactory.createEvent((String)event.getTo(), (String)event.getFrom(), (String)event.getTopic(), (CipherMode)CipherMode.RESPONSE, (String)encSessionKey));
    }

    private void handleKeyResponse(EventDTO event) {
        Activator.getLog().log(4, "Handling Session Key Response for " + event.getFrom() + ".");
        if (event.getBody() == null) {
            Activator.getLog().log(1, "Key Response is null.");
            return;
        }
        String e2estorepass = this.configProperties.get(E2EKEYSTORE_PASSWORD).toString();
        String decSessionKey = RSAManager.decrypt(event.getBody(), "1", e2estorepass);
        if (decSessionKey == null) {
            return;
        }
        if (!decSessionKey.contains(":")) {
            Activator.getLog().log(1, "Invalid format for key response.");
            return;
        }
        if (decSessionKey.split(":")[1].equals("null")) {
            Activator.getLog().log(1, "Responded key is null.");
            return;
        }
        String storingKey = event.getFrom() + "~" + decSessionKey.split(":")[0];
        String encryptionKey = decSessionKey.split(":")[1];
        KeyStorage.getInstance(String.class).store(storingKey, encryptionKey);
        if (this.eventBuffer.containsKey(event.getFrom()) && !this.eventBuffer.get(event.getFrom()).isEmpty()) {
            EventDTO fifoEvent = null;
            while (!this.eventBuffer.get(event.getFrom()).isEmpty()) {
                fifoEvent = this.eventBuffer.get(event.getFrom()).getFirst();
                if (encryptionKey != null) {
                    this.decryptAndPublish(fifoEvent);
                    this.eventBuffer.get(event.getFrom()).removeFirst();
                    Activator.getLog().log(4, "Event from EventBuffer handled and removed for " + event.getFrom());
                    continue;
                }
                return;
            }
            this.eventBuffer.remove(event.getFrom());
            Activator.getLog().log(4, "FIFO EventBuffer removed for " + event.getFrom());
        }
    }

    private void setAutoMode(EventDTO event) {
        String storingKey = event.getFrom() + "~" + "AUTOMODE";
        String mode = event.getCipherState().toString();
        KeyStorage.getInstance(String.class).store(storingKey, mode);
    }

    private void makeKeyRequest(EventDTO event) {
        if (!this.eventBuffer.containsKey(event.getFrom())) {
            this.eventBuffer.put(event.getFrom(), new LinkedList());
            Activator.getLog().log(4, "FIFO EventBuffer created for " + event.getFrom());
        }
        this.eventBuffer.get(event.getFrom()).add(event);
        Activator.getLog().log(4, "Added encrypted event to EventBuffer for " + event.getFrom());
        Activator.getLog().log(4, "Sending a Session Key Request to " + event.getFrom() + ".");
        AddressDTO address = this.addressService.getAddress(event.getFrom());
        this.communicationService.sendMessage(address, DTOFactory.createEvent((String)event.getTo(), (String)event.getFrom(), (String)event.getTopic(), (CipherMode)CipherMode.REQUEST, (String)event.getCipherState().toString().split("_")[0]));
    }

    private void makeCertificateRequest(EventDTO event) {
        if (event.getCipherState().equals((Object)CipherMode.CR_AUTH_REQUEST)) {
            String newTo = event.getFrom();
            try {
                event.setFrom(event.getTo());
                event.setTo(newTo);
            }
            catch (ContentTooLongException contentTooLongException) {
                // empty catch block
            }
        }
        if (!this.eventBuffer.containsKey(REQUEST + event.getFrom())) {
            this.eventBuffer.put(REQUEST + event.getFrom(), new LinkedList());
            Activator.getLog().log(4, "FIFO buffer created for key request event " + event.getFrom());
        }
        this.eventBuffer.get(REQUEST + event.getFrom()).add(event);
        Activator.getLog().log(4, "Added key request event to buffer for " + event.getFrom());
        Activator.getLog().log(4, "Sending a Certificate Request to " + event.getFrom() + ".");
        AddressDTO address = this.addressService.getAddress(event.getFrom());
        this.communicationService.sendMessage(address, DTOFactory.createEvent((String)event.getTo(), (String)event.getFrom(), (String)event.getTopic(), (CipherMode)CipherMode.CERTREQ, (String)"E2ESecurity"));
    }

    private void handleCertificateRequest(EventDTO event) {
        Activator.getLog().log(4, "Handling Certificate Request for " + event.getFrom() + ".");
        Certificate cert = RSAManager.getPublicKeyCertificate(this.configProperties.get(PROVIDER).toString());
        String certString = RSAManager.convertToPem(cert);
        AddressDTO address = this.addressService.getAddress(event.getFrom());
        this.communicationService.sendMessage(address, DTOFactory.createEvent((String)event.getTo(), (String)event.getFrom(), (String)event.getTopic(), (CipherMode)CipherMode.CERTRESP, (String)certString));
    }

    private void handleCertificateResponse(EventDTO event) {
        Activator.getLog().log(4, "Handling Certificate Response for " + event.getFrom() + ".");
        if (event.getBody() == null) {
            Activator.getLog().log(1, "Certificate Response is null.");
            return;
        }
        Certificate cert = RSAManager.getCertFromPem(event.getBody());
        if (cert == null) {
            Activator.getLog().log(1, "Responded Certificate from " + event.getFrom() + " is null.");
            return;
        }
        String truststore = this.configProperties.get(TRUSTEDCERTSTORE_PATH).toString();
        String truststorepass = this.configProperties.get(TRUSTEDCERTSTORE_PASSWORD).toString();
        KeyStore trustStore = RSAManager.loadKeyStore(truststore, truststorepass, "JKS");
        Certificate caCert = null;
        try {
            caCert = trustStore.getCertificate("starballsports.com");
            if (caCert == null) {
                Activator.getLog().log(1, "Loaded certificate for starbaseca is null. Check your cacerts.");
                return;
            }
            cert.verify(caCert.getPublicKey());
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            Activator.getLog().log(1, "Certificate from " + event.getFrom() + " is not trusted.");
            return;
        }
        RSAManager.storePublicKeyCertificate(cert, event.getFrom());
        if (this.eventBuffer.containsKey(REQUEST + event.getFrom()) && !this.eventBuffer.get(REQUEST + event.getFrom()).isEmpty()) {
            EventDTO requestEvent = null;
            while (!this.eventBuffer.get(REQUEST + event.getFrom()).isEmpty()) {
                requestEvent = this.eventBuffer.get(REQUEST + event.getFrom()).getFirst();
                if (requestEvent.getCipherState().equals((Object)CipherMode.CR_AUTH_REQUEST)) {
                    String newTo = requestEvent.getFrom();
                    try {
                        requestEvent.setFrom(event.getTo());
                        requestEvent.setTo(newTo);
                    }
                    catch (ContentTooLongException contentTooLongException) {
                        // empty catch block
                    }
                    this.handleChallenge(requestEvent);
                    Activator.getLog().log(4, "Challenge request handled and removed for " + event.getFrom());
                } else {
                    this.handleKeyRequest(requestEvent);
                    Activator.getLog().log(4, "Session key request handled and removed for " + event.getFrom());
                }
                this.eventBuffer.get(REQUEST + event.getFrom()).removeFirst();
            }
            this.eventBuffer.remove(REQUEST + event.getFrom());
            Activator.getLog().log(4, "Request buffer removed for " + event.getFrom());
        }
    }

    private void decryptAndPublish(EventDTO event) {
        EventDTO decryptedEvent = DTOFactory.createEvent((String)event.getFrom(), (String)event.getTo(), (String)event.getTopic(), (CipherMode)CipherMode.PLAIN, (String)"");
        String decryptedString = null;
        if (event.getCipherState().isRSA()) {
            String e2estore = this.configProperties.get(E2EKEYSTORE_PATH).toString();
            String e2estorepass = this.configProperties.get(E2EKEYSTORE_PASSWORD).toString();
            RSAManager.initDecryptionProvider(e2estore, e2estorepass, "PKCS12", "BouncyCastle");
            decryptedString = RSAManager.decrypt(event.getBody(), "1", e2estorepass);
        } else if (event.getCipherState().isAES()) {
            this.setAutoMode(event);
            String sessionKey = (String)KeyStorage.getInstance(String.class).get(event.getFrom() + "~" + event.getCipherState().toString().split("_")[0]);
            if (sessionKey == null) {
                this.makeKeyRequest(event);
                return;
            }
            decryptedString = AESProvider.getCryptoInstance(event.getCipherState()).setKey(sessionKey).decrypt(event.getBody());
        }
        try {
            decryptedEvent.setBody(decryptedString);
        }
        catch (ContentTooLongException e) {
            Activator.getLog().log(1, "Decrypted EventDTO content to long", (Throwable)e);
        }
        AddressDTO address = this.addressService.getAddress(event.getFrom());
        String tech = address.getTech().split("\\.")[address.getTech().split("\\.").length - 1];
        Activator.getLog().log(3, "Publishing decrypted event to: in." + tech + "." + event.getTopic());
        this.messagingService.publishMessage("in." + tech + "." + event.getTopic(), decryptedEvent);
    }

    private void handleChallenge(EventDTO event) {
        if (!this.eventIsValid(event)) {
            Activator.getLog().log(1, "Invalid EventDTO.");
            return;
        }
        Certificate cert = RSAManager.getPublicKeyCertificate(event.getTo());
        if (cert == null) {
            Activator.getLog().log(4, "No E2E public key certificate available for " + event.getTo());
            this.makeCertificateRequest(event);
        } else {
            String challenge = event.getBody();
            String encChallenge = RSAManager.encrypt(event.getBody(), event.getTo(), null);
            try {
                event.setBody(encChallenge);
            }
            catch (ContentTooLongException contentTooLongException) {
                // empty catch block
            }
            AddressDTO address = this.addressService.getAddress(event.getTo());
            if (this.communicationService.sendMessage(address, event)) {
                this.challenges.put(event.getTo(), challenge);
            }
        }
    }

    public boolean createChallenge(EventDTO event) {
        byte[] key = SecureRandomGenerator.returnKey(32);
        try {
            String challenge = RSAManager.getHexString(key);
            if (challenge == null) {
                Activator.getLog().log(1, "Error while creating challenge for challenge response");
                return false;
            }
            event.setBody(challenge);
        }
        catch (Exception e) {
            Activator.getLog().log(1, "Error while converting byte array to string", (Throwable)e);
        }
        this.handleChallenge(event);
        return true;
    }

    public void push(EventDTO event, String topic) {
        if (!this.eventIsValid(event)) {
            Activator.getLog().log(1, "Invalid EventDTO.");
            return;
        }
        AddressDTO address = this.addressService.getAddress(event.getFrom());
        this.communicationService = this.serviceArray.get(address.getTech());
        if (this.communicationService == null) {
            Activator.getLog().log(2, "unable to send encrypted message, crypto service cannot access communication service: " + address.getTech());
            return;
        }
        if (topic.startsWith("out.crypto")) {
            this.forwardWithCrypto(event, topic);
            return;
        }
        if (event.getCipherState().isKeyRequest()) {
            this.handleKeyRequest(event);
            return;
        }
        if (event.getCipherState().isKeyResponse()) {
            this.handleKeyResponse(event);
            return;
        }
        if (event.getCipherState().isCertRequest()) {
            this.handleCertificateRequest(event);
            return;
        }
        if (event.getCipherState().isCertResponse()) {
            this.handleCertificateResponse(event);
            return;
        }
        if (event.getCipherState().equals((Object)CipherMode.CR_AUTH_REQUEST)) {
            String e2estorepass = this.configProperties.get(E2EKEYSTORE_PASSWORD).toString();
            String challenge = RSAManager.decrypt(event.getBody(), "1", e2estorepass);
            String signedChallenge = RSAManager.sign(challenge, "1", e2estorepass);
            this.communicationService.sendMessage(address, DTOFactory.createEvent((String)event.getTo(), (String)event.getFrom(), (String)event.getTopic(), (CipherMode)CipherMode.CR_AUTH_RESPONSE, (String)signedChallenge));
            return;
        }
        if (event.getCipherState().equals((Object)CipherMode.CR_AUTH_RESPONSE)) {
            boolean authResult = RSAManager.verify(event.getBody(), this.challenges.get(address.getTo()), event.getFrom());
            try {
                event.setBody(String.valueOf(authResult));
            }
            catch (ContentTooLongException contentTooLongException) {
                // empty catch block
            }
            Activator.getLog().log(3, "Publishing authentication event to: in.challenge.response." + event.getFrom());
            this.messagingService.publishMessage("in.challenge.response." + event.getFrom(), event);
            return;
        }
        this.decryptAndPublish(event);
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
        Activator.getLog().log(3, "MessagingService injected");
    }

    public void setCommunicationService(Map<String, CommunicationService> serviceArray) {
        this.serviceArray = serviceArray;
        Activator.getLog().log(3, "CommunicationServices injected");
    }

    public void setAddressService(AddressService addressService) {
        this.addressService = addressService;
        Activator.getLog().log(3, "AddressService injected");
    }

    public Dictionary<String, ?> getDefaultConfiguration() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put(PROVIDER, "BouncyCastle");
        ((Dictionary)properties).put(KEYSTORE_PATH, "./keystore/keystore_[bundlename].p12");
        ((Dictionary)properties).put(KEYSTORE_PASSWORD, "fredosar");
        ((Dictionary)properties).put(TRUSTEDCERTSTORE_PATH, "./keystore/cacerts");
        ((Dictionary)properties).put(TRUSTEDCERTSTORE_PASSWORD, "changeit");
        ((Dictionary)properties).put(E2EKEYSTORE_PATH, "./keystore/keystore_end2end.p12");
        ((Dictionary)properties).put(E2EKEYSTORE_PASSWORD, "fredosar");
        ((Dictionary)properties).put(STARBASECERTSTORE_PATH, "./keystore/starbasecerts.jks");
        ((Dictionary)properties).put(STARBASECERTSTORE_PASSWORD, "fredosar");
        return properties;
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            Activator.getLog().log(2, "Configuration properties are null.");
            return;
        }
        String provider = properties.get(PROVIDER).toString();
        String certstore = properties.get(STARBASECERTSTORE_PATH).toString();
        String certstorepass = properties.get(STARBASECERTSTORE_PASSWORD).toString();
        String e2estore = properties.get(E2EKEYSTORE_PATH).toString();
        String e2estorepass = properties.get(E2EKEYSTORE_PASSWORD).toString();
        if (this.configProperties != null) {
            if (this.configProperties != properties) {
                Activator.getLog().log(4, "Configuration properties changed");
                if (properties.get(PROVIDER) != null && !properties.get(PROVIDER).equals(this.configProperties.get(PROVIDER))) {
                    RSAManager.initDecryptionProvider(e2estore, e2estorepass, "PKCS12", provider);
                    RSAManager.initSigningProvider(e2estore, e2estorepass, "PKCS12", provider);
                    RSAManager.initEncryptionProvider(certstore, certstorepass, "JKS", provider);
                    RSAManager.initVerificationProvider(certstore, certstorepass, "JKS", provider);
                    RSAManager.initPublicCertStore(certstore, certstorepass, "JKS");
                }
            }
        } else {
            RSAManager.initDecryptionProvider(e2estore, e2estorepass, "PKCS12", provider);
            RSAManager.initSigningProvider(e2estore, e2estorepass, "PKCS12", provider);
            RSAManager.initEncryptionProvider(certstore, certstorepass, "JKS", provider);
            RSAManager.initVerificationProvider(certstore, certstorepass, "JKS", provider);
            RSAManager.initPublicCertStore(certstore, certstorepass, "JKS");
        }
        RSAManager.initDecryptionProvider(e2estore, e2estorepass, "PKCS12", provider);
        RSAManager.initSigningProvider(e2estore, e2estorepass, "PKCS12", provider);
        RSAManager.initEncryptionProvider(certstore, certstorepass, "JKS", provider);
        RSAManager.initVerificationProvider(certstore, certstorepass, "JKS", provider);
        RSAManager.initPublicCertStore(certstore, certstorepass, "JKS");
        this.configProperties = properties;
    }
}

