/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto.impl;

import com.starbase.core.DTOFactory;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.crypto.Activator;
import com.starbase.core.crypto.algorithms.aes.AESProvider;
import com.starbase.core.crypto.algorithms.rsa.RSAManager;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.crypto.api.CipherSuite;
import com.starbase.core.crypto.api.CryptoService;
import com.starbase.core.crypto.impl.CipherSuiteImpl;
import com.starbase.core.crypto.impl.CryptoManager;
import com.starbase.core.crypto.keys.KeyStorage;
import com.starbase.core.exception.io.ContentTooLongException;
import com.starbase.core.messaging.dto.EventDTO;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.osgi.framework.Bundle;

public class CryptoServiceProxy
implements CryptoService {
    private Bundle bundle;
    private CipherSuite cipherSuite;
    private CryptoManager cryptoServiceManager;

    public CryptoServiceProxy(CryptoManager cryptoServiceManager, Bundle bundle) {
        this.cryptoServiceManager = cryptoServiceManager;
        this.bundle = bundle;
    }

    public boolean sendMessage(AddressDTO address, EventDTO eventDTO, CipherMode cipherMode, CommunicationService communicationService) {
        CipherMode mode;
        if (Activator.getDEVICE_ID().equals("00000000")) {
            Activator.getLog().log(2, "\n======================================================================================\nHINT: YOUR SYSTEM IS NOT SECURE. YOU ARE PROBABLY USING THE DEFAULT STARBASE KEYSTORE!\n======================================================================================");
        }
        if ((mode = cipherMode).equals((Object)CipherMode.AUTO)) {
            String modeString = (String)KeyStorage.getInstance(String.class).get(eventDTO.getTo() + "~" + "AUTOMODE");
            mode = modeString == null ? CipherMode.PLAIN : CipherMode.valueOf((String)modeString);
        }
        if (mode.equals((Object)CipherMode.PLAIN)) {
            return communicationService.sendMessage(address, eventDTO);
        }
        if (mode.equals((Object)CipherMode.CR_AUTH_REQUEST)) {
            return this.cryptoServiceManager.createChallenge(eventDTO);
        }
        EventDTO encryptedDTO = null;
        try {
            encryptedDTO = CryptoServiceProxy.encryptEventDTO(address.getIdentifier(), eventDTO, mode);
        }
        catch (ContentTooLongException e) {
            Activator.getLog().log(1, "Encrypted EventDTO content to long", (Throwable)e);
            return false;
        }
        return communicationService.sendMessage(address, encryptedDTO);
    }

    private static EventDTO encryptEventDTO(String uniqueIdentifier, EventDTO eventDTO, CipherMode cipherMode) throws ContentTooLongException {
        EventDTO encryptedDTO = DTOFactory.createEvent((String)eventDTO.getFrom(), (String)eventDTO.getTo(), (String)eventDTO.getTopic(), (CipherMode)cipherMode, (String)eventDTO.getBody());
        if (cipherMode.isRSA()) {
            encryptedDTO.setBody(RSAManager.encrypt(encryptedDTO.getBody(), eventDTO.getTo(), null));
        } else if (cipherMode.isAES()) {
            encryptedDTO.setBody(AESProvider.getCryptoInstance(cipherMode).setKey(CryptoServiceProxy.getKey(uniqueIdentifier, cipherMode)).encrypt(encryptedDTO.getBody()));
        } else {
            Activator.getLog().log(1, "Unknown CipherMode " + cipherMode + " for EventDTO encryption.");
            return null;
        }
        Activator.getLog().log(3, "Encrypting EventDTO with " + cipherMode);
        return encryptedDTO;
    }

    private static String getKey(String uniqueIdentifier, CipherMode cipherMode) {
        String sessionKey = null;
        try {
            if (KeyStorage.getInstance(String.class) != null) {
                sessionKey = (String)KeyStorage.getInstance(String.class).get(uniqueIdentifier + "~" + cipherMode.toString().split("_")[0]);
            }
            if (sessionKey == null) {
                sessionKey = AESProvider.generateKeyString(cipherMode);
                KeyStorage.getInstance(String.class).store(uniqueIdentifier + "~" + cipherMode.toString().split("_")[0], sessionKey);
            }
        }
        catch (Throwable e) {
            Activator.getLog().log(1, "exception in crypto ", e);
        }
        return sessionKey;
    }

    public SSLContext getSSLContext() {
        SSLContext sslContext = null;
        KeyManagerFactory kmf = null;
        try {
            char[] keyPassphrase = this.cryptoServiceManager.configProperties.get("keystore.password").toString().toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(new FileInputStream(this.cryptoServiceManager.configProperties.get("keystore.path").toString().replace("[bundlename]", this.bundle.getSymbolicName())), keyPassphrase);
            kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, keyPassphrase);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            Activator.getLog().log(1, "SSL failed", (Throwable)e);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            char[] trustedPassphrase = this.cryptoServiceManager.configProperties.get("trustedcertstore.password").toString().toCharArray();
            KeyStore tks = KeyStore.getInstance("JKS");
            tks.load(new FileInputStream(this.cryptoServiceManager.configProperties.get("trustedcertstore.path").toString().replace("[bundlename]", this.bundle.getSymbolicName())), trustedPassphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(tks);
            sslContext = SSLContext.getInstance("TLSv1.2");
            if (kmf == null) {
                sslContext.init(null, tmf.getTrustManagers(), null);
            } else {
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Activator.getLog().log(4, "Private SSL failed. Providing general SSL Context");
            try {
                sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, null, null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e1) {
                Activator.getLog().log(1, "General SSL failed.", (Throwable)e);
                return null;
            }
        }
        Activator.getLog().log(3, "providing SSLContext for bundle " + this.bundle.getSymbolicName() + " and crypto manager " + this.cryptoServiceManager);
        return sslContext;
    }

    public CipherSuite getCipherSuite() {
        if (this.cipherSuite == null) {
            this.cipherSuite = new CipherSuiteImpl();
        }
        return this.cipherSuite;
    }
}

