/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto.keys;

import com.starbase.core.crypto.Activator;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyStorage<T>
extends HashMap<String, T> {
    private static final long serialVersionUID = 1L;
    private static ArrayList<Class<?>> allowedDataTypes;
    private static HashMap<String, KeyStorage<?>> storages;

    private KeyStorage(T type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> KeyStorage<?> getInstance(T type) {
        HashMap<String, KeyStorage<?>> hashMap = storages;
        synchronized (hashMap) {
            if (!storages.containsKey(type.toString())) {
                KeyStorage<T> storage = new KeyStorage<T>(type);
                storages.put(type.toString(), storage);
                Activator.getLog().log(3, "Created new Hashmap for type: " + type.toString());
            }
            return storages.get(type.toString());
        }
    }

    public void store(String key, Object o) {
        this.put(key, o);
        Activator.getLog().log(3, "Storing key material for: " + key + ". Type: " + o.getClass().toString());
    }

    public static boolean allows(Class<?> clazz) {
        return allowedDataTypes.contains(clazz);
    }

    public static boolean init() {
        storages.clear();
        Activator.getLog().log(3, "Loading certificates into key storage.");
        return true;
    }

    public static boolean backup() {
        Activator.getLog().log(3, "Saving certificates from (volatile) key storage.");
        storages.clear();
        return true;
    }

    static {
        storages = new HashMap();
        allowedDataTypes = new ArrayList();
        allowedDataTypes.add(String.class);
        allowedDataTypes.add(SecretKey.class);
        allowedDataTypes.add(SecretKeySpec.class);
        allowedDataTypes.add(KeyPair.class);
    }
}

