/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;

public class Utilities {
    public static String dateToTimestamp(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(date);
    }

    public static Date timestampToDate(String timestamp) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").parse(timestamp);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static String filterUserInputForSpecChars(String input) {
        String res = input.replaceAll("[^a-zA-Z0-9\\.\\-\\_]+", "");
        return res;
    }

    public static String generateStarbaseType(Class<?> clazz) {
        return clazz.getName().replaceFirst(Pattern.quote("com.starbase.core.types."), "");
    }

    public static String truncate(String input, int maxLen) {
        return input.length() <= maxLen ? input : input.substring(0, maxLen);
    }

    public static int getLogLevelForBundle(Bundle b, String logLevelConfig) {
        try {
            return Integer.valueOf(logLevelConfig);
        }
        catch (NumberFormatException numberFormatException) {
            int defaultLevel = 5;
            String[] split = logLevelConfig.split(";");
            if (split == null || logLevelConfig.equals("")) {
                return defaultLevel;
            }
            for (String entry : split) {
                try {
                    defaultLevel = Integer.valueOf(entry);
                }
                catch (NumberFormatException numberFormatException2) {
                    String[] entrySplit = entry.split("=", 2);
                    String bundleName = entrySplit[0];
                    bundleName = bundleName.replace("*", "(.*)");
                    if (!b.getSymbolicName().matches(bundleName)) continue;
                    try {
                        defaultLevel = Integer.valueOf(entrySplit[1]);
                    }
                    catch (NumberFormatException e) {
                        return defaultLevel;
                    }
                }
            }
            return defaultLevel;
        }
    }

    public static String getLogLevel(int level) {
        switch (level) {
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "INFO";
            }
            case 4: {
                return "DEBUG";
            }
            case 5: {
                return "OSGI";
            }
        }
        return "UNKNOWN";
    }
}

