/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.crypto.api;

import java.util.ArrayList;

public enum CipherMode {
    PLAIN,
    REQUEST,
    RESPONSE,
    CERTREQ,
    CERTRESP,
    CR_AUTH_REQUEST,
    CR_AUTH_RESPONSE,
    AUTO,
    AES192_GCM,
    AES128_GCM,
    AES256_GCM,
    AES128_CCM,
    AES192_CCM,
    AES256_CCM,
    AES128_CBC,
    AES192_CBC,
    AES256_CBC,
    AES128_CBC_HS256,
    AES192_CBC_HS384,
    AES256_CBC_HS512,
    RSA_ECB;

    static ArrayList<String> entries;

    static boolean contains(String cipherMode) {
        return entries.contains(cipherMode);
    }

    static CipherMode get(String cipherMode) {
        return CipherMode.valueOf(cipherMode);
    }

    public static ArrayList<String> getModes() {
        return entries;
    }

    public boolean isAES() {
        return this.toString().startsWith("AES");
    }

    public boolean isRSA() {
        return this.toString().startsWith("RSA");
    }

    public boolean isKeyRequest() {
        return this.toString().startsWith("REQUEST");
    }

    public boolean isKeyResponse() {
        return this.toString().startsWith("RESPONSE");
    }

    public boolean isCertRequest() {
        return this.equals((Object)CERTREQ);
    }

    public boolean isCertResponse() {
        return this.equals((Object)CERTRESP);
    }

    static {
        entries = new ArrayList();
        for (CipherMode cipherMode : CipherMode.values()) {
            entries.add(cipherMode.name());
        }
    }
}

