/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.log.impl;

import com.starbase.core.Utilities;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.log.Activator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class SimpleConsoleLogger
implements LogListener,
ConfiguredService,
ManagedService {
    private String logLevelConfig = "2";
    private boolean printException = false;

    public void logged(LogEntry entry) {
        int currentLevel = entry.getLevel();
        if (entry.getMessage().startsWith("ServiceEvent") || entry.getMessage().startsWith("BundleEvent") || entry.getMessage().startsWith("FrameworkEvent")) {
            currentLevel = 5;
        }
        if (entry.getMessage().equals("getProperties()") && entry.getBundle().getSymbolicName().equals("org.apache.felix.configadmin")) {
            return;
        }
        if (currentLevel <= Utilities.getLogLevelForBundle((Bundle)entry.getBundle(), (String)this.logLevelConfig)) {
            DateTimeFormatter timeStampPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
            String timeString = timeStampPattern.format(LocalDateTime.now());
            System.out.println(timeString + "|" + Utilities.getLogLevel((int)currentLevel) + ":" + entry.getBundle().getSymbolicName() + " " + entry.getBundle().getBundleId() + "> " + entry.getMessage());
            if (this.printException && entry.getException() != null) {
                entry.getException().printStackTrace();
            }
        }
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        if (Utilities.getLogLevelForBundle((Bundle)Activator.getContext().getBundle(), (String)this.logLevelConfig) >= 3) {
            System.out.println("INFO:com.starbase.core.log> updating config: " + properties);
        }
        if (properties.get("level") != null) {
            this.logLevelConfig = properties.get("level").toString();
        }
        if (properties.get("print_exception") != null) {
            boolean exception = false;
            try {
                exception = Boolean.valueOf(properties.get("print_exception").toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.printException = exception;
        }
    }

    public Dictionary<String, ?> getDefaultConfiguration() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("level", "4");
        ((Dictionary)properties).put("print_exception", "true");
        return properties;
    }
}

