/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.mapping;

import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.MappingServiceAwareTracker;
import com.starbase.core.mapping.MappingServiceTracker;
import com.starbase.core.mapping.MappingTableServiceAwareTracker;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingTableService;
import com.starbase.core.mapping.api.MappingTableServiceAware;
import com.starbase.core.mapping.impl.MappingTableServiceImpl;
import com.starbase.core.mapping.json.impl.JacksonMappingServiceImpl;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;
    private static MappingTableServiceAwareTracker mappingTableServiceAwareTracker;

    public static LogService getLog() {
        return logServiceTracker.getService();
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        MappingTableServiceImpl messageTableService = new MappingTableServiceImpl();
        context.registerService(MappingTableService.class, (Object)messageTableService, null);
        mappingTableServiceAwareTracker = new MappingTableServiceAwareTracker(context);
        mappingTableServiceAwareTracker.setMappingTableService(messageTableService);
        mappingTableServiceAwareTracker.open();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", "com.starbase.core.mapping.json");
        ((Dictionary)properties).put("map_type", "JSON");
        context.registerService(new String[]{MappingService.class.getName(), MappingTableServiceAware.class.getName()}, (Object)new JacksonMappingServiceImpl(), properties);
        MappingServiceTracker.getInstance();
        MappingServiceAwareTracker.getInstance();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        mappingTableServiceAwareTracker.close();
        MappingServiceTracker.getInstance().close();
        MappingServiceAwareTracker.getInstance().close();
        logServiceTracker.close();
        context = null;
    }
}

