/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.mapping;

import com.starbase.core.mapping.Activator;
import com.starbase.core.mapping.MappingServiceTracker;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.mapping.json.impl.JacksonMappingServiceImpl;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MappingServiceAwareTracker
extends ServiceTracker<MappingServiceAware, MappingServiceAware> {
    private static MappingServiceAwareTracker instance;
    private ServiceTracker<MappingService, MappingService> mappingServiceTracker = MappingServiceTracker.getInstance();

    public static MappingServiceAwareTracker getInstance() {
        if (instance == null) {
            instance = new MappingServiceAwareTracker();
            instance.open();
        }
        return instance;
    }

    private MappingServiceAwareTracker() {
        super(Activator.getContext(), MappingServiceAware.class, null);
    }

    public MappingServiceAware addingService(ServiceReference<MappingServiceAware> reference) {
        MappingServiceAware sv = (MappingServiceAware)super.addingService(reference);
        this.updateSingleMappingServiceAware(reference, sv, null, null);
        return sv;
    }

    public void modifiedService(ServiceReference<MappingServiceAware> reference, MappingServiceAware service) {
        super.modifiedService(reference, (Object)service);
        this.updateSingleMappingServiceAware(reference, service, null, null);
    }

    public void updateMappingServiceAwareEntries(ServiceReference<MappingService> reference, MappingService service) {
        Set services = this.getTracked().entrySet();
        for (Map.Entry entry : services) {
            this.updateSingleMappingServiceAware((ServiceReference<MappingServiceAware>)((ServiceReference)entry.getKey()), (MappingServiceAware)entry.getValue(), reference, service);
        }
    }

    private void updateSingleMappingServiceAware(ServiceReference<MappingServiceAware> reference, MappingServiceAware sv, ServiceReference<MappingService> dsReference, MappingService dsService) {
        Object typeFilter = reference.getProperty("map_type");
        if (typeFilter == null) {
            if (dsService != null && dsService instanceof JacksonMappingServiceImpl) {
                Activator.getLog().log(4, "injecting " + sv.getClass().getSimpleName() + " with Mapping Service type JSON (standard mapping service)");
                sv.setMappingService(dsService);
                return;
            }
            typeFilter = "JSON";
            Set services = this.mappingServiceTracker.getTracked().entrySet();
            for (Map.Entry entry : services) {
                ServiceReference sr = (ServiceReference)entry.getKey();
                MappingService so = (MappingService)entry.getValue();
                if (sr.getProperty("map_type") == null || !sr.getProperty("map_type").equals(typeFilter)) continue;
                Activator.getLog().log(4, "injecting " + sv.getClass().getSimpleName() + " with Mapping Service type " + typeFilter + " (standard mapping service)");
                sv.setMappingService(so);
                return;
            }
        } else {
            if (dsReference != null && dsService != null && dsReference.getProperty("map_type") != null && dsReference.getProperty("map_type").equals(typeFilter)) {
                Activator.getLog().log(4, "injecting " + sv.getClass().getSimpleName() + " with Mapping Service type " + typeFilter);
                sv.setMappingService(dsService);
                return;
            }
            Set services = this.mappingServiceTracker.getTracked().entrySet();
            for (Map.Entry entry : services) {
                ServiceReference sr = (ServiceReference)entry.getKey();
                MappingService so = (MappingService)entry.getValue();
                if (sr.getProperty("map_type") == null || !sr.getProperty("map_type").equals(typeFilter)) continue;
                Activator.getLog().log(4, "injecting " + sv.getClass().getSimpleName() + " with Mapping Service type " + typeFilter);
                sv.setMappingService(so);
                return;
            }
            Activator.getLog().log(2, "could not inject " + sv.getClass().getSimpleName());
        }
    }
}

