/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.mapping.json.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.starbase.core.exception.general.BadRequestException;
import com.starbase.core.exception.general.ServiceMissingException;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingTableService;
import com.starbase.core.mapping.api.MappingTableServiceAware;
import java.util.ArrayList;

public class JacksonMappingServiceImpl
implements MappingService,
MappingTableServiceAware {
    private ObjectMapper mapper = new ObjectMapper();
    private MappingTableService mappingTable;

    public JacksonMappingServiceImpl() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Object mapToObject(String data, String classIdentifierField) throws Exception {
        if (this.mappingTable == null) {
            throw new ServiceMissingException("mapping table not injected");
        }
        JsonNode rootNode = this.mapper.readTree(data);
        if (rootNode.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonNode jsonNode : rootNode) {
                list.add(this.mapToObject(this.mapper.writeValueAsString((Object)jsonNode), this.mappingTable.getClassByIdentifier(jsonNode.get(classIdentifierField).asText())));
            }
            return list;
        }
        if (rootNode.isObject()) {
            return this.mapToObject(data, this.mappingTable.getClassByIdentifier(rootNode.get(classIdentifierField).asText()));
        }
        throw new BadRequestException("Neither array nor object!");
    }

    public Object mapToObject(String data, Class<?> clazz) throws Exception {
        return this.mapper.readValue(data, clazz);
    }

    public String mapToString(Object obj) throws Exception {
        return this.mapper.writeValueAsString(obj);
    }

    public Object mergeObject(String data, Object obj) throws Exception {
        ObjectReader updater = this.mapper.readerForUpdating(obj);
        obj = updater.readValue(data);
        return obj;
    }

    public void setMappingTableService(MappingTableService mappingTableService) {
        this.mappingTable = mappingTableService;
    }
}

