/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.messaging;

import com.starbase.core.auth.api.ModuleAuthorizationService;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.messaging.MessagingConsumerServiceTracker;
import com.starbase.core.messaging.MessagingServiceAwareTracker;
import com.starbase.core.messaging.MessagingServiceTracker;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.impl.SimpleMessagingServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private MessagingConsumerServiceTracker messagingConsumerServiceTracker;
    private MessagingServiceAwareTracker messagingServiceAwareTracker;
    private MessagingServiceTracker messagingServiceTracker;
    private static ServiceTracker<ModuleAuthorizationService, ModuleAuthorizationService> moduleAuthorizationServiceTracker;
    private static LogServiceTracker logServiceTracker;
    private static ModuleAuthorizationService moduleAuthorizationService;

    public static ModuleAuthorizationService getModuleAuthorizationService() {
        return moduleAuthorizationService;
    }

    public static LogService getLog() {
        return logServiceTracker == null ? null : logServiceTracker.getService();
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        this.messagingConsumerServiceTracker = new MessagingConsumerServiceTracker(bundleContext);
        this.messagingServiceAwareTracker = new MessagingServiceAwareTracker(bundleContext);
        moduleAuthorizationServiceTracker = new ServiceTracker<ModuleAuthorizationService, ModuleAuthorizationService>(context, ModuleAuthorizationService.class, null){

            public ModuleAuthorizationService addingService(ServiceReference<ModuleAuthorizationService> reference) {
                ModuleAuthorizationService service = (ModuleAuthorizationService)super.addingService(reference);
                moduleAuthorizationService = service;
                if (Activator.this.messagingConsumerServiceTracker.getService() != null) {
                    Activator.getLog().log(3, "retry updating message consumers");
                    Activator.this.messagingConsumerServiceTracker.updateMessageConsumers();
                }
                return service;
            }

            public void modifiedService(ServiceReference<ModuleAuthorizationService> reference, ModuleAuthorizationService service) {
                super.modifiedService(reference, (Object)service);
                moduleAuthorizationService = service;
                if (Activator.this.messagingConsumerServiceTracker.getService() != null) {
                    Activator.getLog().log(3, "retry updating message consumers");
                    Activator.this.messagingConsumerServiceTracker.updateMessageConsumers();
                }
            }
        };
        this.messagingServiceTracker = new MessagingServiceTracker(bundleContext, this.messagingConsumerServiceTracker, this.messagingServiceAwareTracker);
        SimpleMessagingServiceImpl messagingServiceImpl = new SimpleMessagingServiceImpl();
        context.registerService(MessagingService.class, (Object)messagingServiceImpl, null);
        this.messagingServiceTracker.open();
        this.messagingConsumerServiceTracker.open();
        this.messagingServiceAwareTracker.open();
        moduleAuthorizationServiceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.messagingConsumerServiceTracker.close();
        this.messagingServiceAwareTracker.close();
        this.messagingServiceTracker.close();
        moduleAuthorizationServiceTracker.close();
        logServiceTracker.close();
        context = null;
    }
}

