/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.messaging;

import com.starbase.core.auth.api.ModuleAuthorizationService;
import com.starbase.core.messaging.Activator;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MessagingConsumerServiceTracker
extends ServiceTracker<MessageConsumer, MessageConsumer> {
    private MessagingService messagingService;

    public MessagingConsumerServiceTracker(BundleContext context) {
        super(context, MessageConsumer.class, null);
    }

    public MessageConsumer addingService(ServiceReference<MessageConsumer> reference) {
        MessageConsumer sv = (MessageConsumer)super.addingService(reference);
        if (this.messagingService != null) {
            this.addMessageSubscriber(reference.getBundle(), sv, (String[])reference.getProperty("topic"));
        }
        return sv;
    }

    public void removedService(ServiceReference<MessageConsumer> reference, MessageConsumer service) {
        if (this.messagingService != null) {
            this.messagingService.removeSubscriber(service, (String[])reference.getProperty("topic"));
        }
        super.removedService(reference, (Object)service);
    }

    public void updateMessagingService(MessagingService sv) {
        this.messagingService = sv;
        this.updateMessageConsumers();
    }

    public void updateMessageConsumers() {
        Set services = this.getTracked().entrySet();
        for (Map.Entry entry : services) {
            this.addMessageSubscriber(((ServiceReference)entry.getKey()).getBundle(), (MessageConsumer)entry.getValue(), (String[])((ServiceReference)entry.getKey()).getProperty("topic"));
        }
    }

    private void addMessageSubscriber(Bundle bundle, MessageConsumer sv, String[] topics) {
        ArrayList<String> filteredTopics = new ArrayList<String>();
        if (topics == null) {
            Activator.getLog().log(2, "unable to add consumer (" + bundle.getSymbolicName() + "), no Constants.MSG_TOPIC property set in Service Registration");
            return;
        }
        ModuleAuthorizationService moduleAuthorizationService = Activator.getModuleAuthorizationService();
        if (moduleAuthorizationService == null) {
            Activator.getLog().log(2, "unable to add consumer (" + bundle.getSymbolicName() + " -- " + topics[0] + "), no ModAuthSv");
            return;
        }
        for (String topic : topics) {
            if (!moduleAuthorizationService.authorizeMessagingTopic(bundle, topic, 1)) continue;
            filteredTopics.add(topic);
        }
        String[] allowedTopicArray = new String[filteredTopics.size()];
        allowedTopicArray = filteredTopics.toArray(allowedTopicArray);
        this.messagingService.addSubscriber(sv, allowedTopicArray);
    }
}

