/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.messaging;

import com.starbase.core.messaging.MessagingServiceVerification;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MessagingServiceAwareTracker
extends ServiceTracker<MessagingServiceAware, MessagingServiceAware> {
    private MessagingService messagingService;
    private HashMap<Bundle, MessagingServiceVerification> messagingServiceProxyCache = new HashMap();

    public MessagingServiceAwareTracker(BundleContext context) {
        super(context, MessagingServiceAware.class, null);
    }

    public MessagingServiceAware addingService(ServiceReference<MessagingServiceAware> reference) {
        MessagingServiceAware sv = (MessagingServiceAware)super.addingService(reference);
        if (this.messagingService != null) {
            this.setMessagingService(sv, reference.getBundle());
        }
        return sv;
    }

    private void setMessagingService(MessagingServiceAware sv, Bundle bundle) {
        if (this.messagingServiceProxyCache.containsKey(bundle)) {
            MessagingServiceVerification messagingServiceProxy = this.messagingServiceProxyCache.get(bundle);
            messagingServiceProxy.setMessagingService(this.messagingService);
            sv.setMessagingService((MessagingService)messagingServiceProxy);
        } else {
            MessagingServiceVerification verificationService = new MessagingServiceVerification(this.messagingService, bundle);
            this.messagingServiceProxyCache.put(bundle, verificationService);
            sv.setMessagingService((MessagingService)verificationService);
        }
    }

    public void removedService(ServiceReference<MessagingServiceAware> reference, MessagingServiceAware service) {
        super.removedService(reference, (Object)service);
        this.messagingServiceProxyCache.remove(reference.getBundle());
    }

    public void updateMessagingService(MessagingService sv) {
        this.messagingService = sv;
        Set services = this.getTracked().entrySet();
        for (Map.Entry entry : services) {
            this.setMessagingService((MessagingServiceAware)entry.getValue(), ((ServiceReference)entry.getKey()).getBundle());
        }
    }
}

