/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.messaging;

import com.starbase.core.messaging.Activator;
import com.starbase.core.messaging.MessagingConsumerServiceTracker;
import com.starbase.core.messaging.MessagingServiceAwareTracker;
import com.starbase.core.messaging.api.MessagingService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MessagingServiceTracker
extends ServiceTracker<MessagingService, MessagingService> {
    private MessagingConsumerServiceTracker consumer;
    private MessagingServiceAwareTracker aware;
    private MessagingService currentService;

    public MessagingServiceTracker(BundleContext context, MessagingConsumerServiceTracker consumer, MessagingServiceAwareTracker aware) {
        super(context, MessagingService.class, null);
        this.consumer = consumer;
        this.aware = aware;
    }

    public MessagingService addingService(ServiceReference<MessagingService> reference) {
        MessagingService sv;
        this.currentService = sv = (MessagingService)super.addingService(reference);
        this.consumer.updateMessagingService(this.currentService);
        this.aware.updateMessagingService(this.currentService);
        Activator.getLog().log(3, "Injected messaging instance " + sv.getClass().getSimpleName());
        return sv;
    }

    public void removedService(ServiceReference<MessagingService> reference, MessagingService service) {
        super.removedService(reference, (Object)service);
        this.currentService = (MessagingService)this.getService();
        if (this.currentService != null) {
            this.consumer.updateMessagingService(this.currentService);
            this.aware.updateMessagingService(this.currentService);
        }
    }
}

