/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.messaging;

import com.starbase.core.auth.api.ModuleAuthorizationService;
import com.starbase.core.messaging.Activator;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.dto.EventDTO;
import org.osgi.framework.Bundle;

public class MessagingServiceVerification
implements MessagingService {
    private MessagingService messagingService;
    private Bundle bundle;

    public MessagingServiceVerification(MessagingService sv, Bundle b) {
        this.messagingService = sv;
        this.bundle = b;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public boolean publishMessage(String topic, EventDTO event) {
        ModuleAuthorizationService moduleAuthorizationService = Activator.getModuleAuthorizationService();
        if (moduleAuthorizationService != null && moduleAuthorizationService.authorizeMessagingTopic(this.bundle, topic, 2)) {
            return this.messagingService.publishMessage(topic, event);
        }
        return false;
    }

    public void addSubscriber(MessageConsumer consumer, String[] topics) {
        this.messagingService.addSubscriber(consumer, topics);
    }

    public void removeSubscriber(MessageConsumer consumer, String[] topics) {
        this.messagingService.removeSubscriber(consumer, topics);
    }
}

