/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.security;

import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.SocketPermission;
import java.security.AllPermission;
import java.util.List;
import java.util.PropertyPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.service.condpermadmin.BundleLocationCondition;
import org.osgi.service.condpermadmin.BundleSignerCondition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionInfo;

public class Activator
implements BundleActivator {
    private static BundleContext context;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        ConditionalPermissionAdmin cpa;
        String cert = "CN=starballsports.com,OU=SBS,O=SBS,L=Salzburg,ST=Salzburg,C=AT";
        context = bundleContext;
        ServiceReference sref = context.getServiceReference(ConditionalPermissionAdmin.class);
        if (sref == null) {
            System.exit(1);
        }
        if ((cpa = (ConditionalPermissionAdmin)context.getService(sref)) == null) {
            System.exit(2);
        }
        ConditionalPermissionUpdate update = cpa.newConditionalPermissionUpdate();
        List inf = update.getConditionalPermissionInfos();
        inf.clear();
        inf.add(cpa.newConditionalPermissionInfo("Felix Framework Bundles", new ConditionInfo[]{new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{"file:/*/bundle/*"})}, new PermissionInfo[]{new PermissionInfo(AllPermission.class.getName(), "*", "*")}, "allow"));
        inf.add(cpa.newConditionalPermissionInfo("STARBASE Security Bundle", new ConditionInfo[]{new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{context.getBundle().getLocation()})}, new PermissionInfo[]{new PermissionInfo(AllPermission.class.getName(), "*", "*")}, "allow"));
        PermissionInfo[] applicationPermissions = new PermissionInfo[]{new PermissionInfo(PackagePermission.class.getName(), "*", "import"), new PermissionInfo(ServicePermission.class.getName(), "org.osgi.service.log.LogService", "get"), new PermissionInfo(ServicePermission.class.getName(), "com.starbase.core.communication.api.AddressServiceAware", "register"), new PermissionInfo(ServicePermission.class.getName(), "com.starbase.core.communication.api.CommunicationServicesAware", "register"), new PermissionInfo(ServicePermission.class.getName(), "com.starbase.core.webserver.api.HTTPService", "register"), new PermissionInfo(ServicePermission.class.getName(), "com.starbase.core.messaging.api.MessagingServiceAware", "register"), new PermissionInfo(ServicePermission.class.getName(), "com.starbase.core.datastore.api.DataStoreServiceAware", "register"), new PermissionInfo(ServicePermission.class.getName(), "com.starbase.core.mapping.api.MappingServiceAware", "register"), new PermissionInfo(ServicePermission.class.getName(), "com.starbase.core.mapping.api.MappingTableServiceAware", "register"), new PermissionInfo(ServicePermission.class.getName(), "com.starbase.core.messaging.api.MessageConsumer", "register"), new PermissionInfo(ServicePermission.class.getName(), "com.starbase.core.crypto.api.CryptoServiceAware", "register"), new PermissionInfo(RuntimePermission.class.getName(), "*", "accessDeclaredMembers"), new PermissionInfo(ReflectPermission.class.getName(), "*", "suppressAccessChecks")};
        PermissionInfo[] cryptoPermissions = new PermissionInfo[]{new PermissionInfo(FilePermission.class.getName(), "./keystore/keystore_end2end.p12", "read,write")};
        PermissionInfo[] corePermissions = new PermissionInfo[]{new PermissionInfo(ServicePermission.class.getName(), "*", "get,register"), new PermissionInfo(PackagePermission.class.getName(), "*", "import"), new PermissionInfo(RuntimePermission.class.getName(), "*", "accessDeclaredMembers"), new PermissionInfo(ReflectPermission.class.getName(), "*", "suppressAccessChecks"), new PermissionInfo(FilePermission.class.getName(), "./store/*", "read,write"), new PermissionInfo(FilePermission.class.getName(), "./store", "read,write"), new PermissionInfo(FilePermission.class.getName(), "./permissions.txt", "read,write"), new PermissionInfo(FilePermission.class.getName(), "./log.txt", "read"), new PermissionInfo(FilePermission.class.getName(), "./log.txt", "write"), new PermissionInfo(PropertyPermission.class.getName(), "os.name", "read"), new PermissionInfo(PropertyPermission.class.getName(), "os.arch", "read"), new PermissionInfo(PropertyPermission.class.getName(), "java.vendor", "read"), new PermissionInfo(PropertyPermission.class.getName(), "java.version", "read"), new PermissionInfo(PropertyPermission.class.getName(), "file.encoding", "read"), new PermissionInfo(SocketPermission.class.getName(), "*:3306", "connect"), new PermissionInfo(SocketPermission.class.getName(), "*:80", "connect"), new PermissionInfo(SocketPermission.class.getName(), "*:8080", "connect"), new PermissionInfo(SocketPermission.class.getName(), "*:443", "connect"), new PermissionInfo(SocketPermission.class.getName(), "*:8443", "connect"), new PermissionInfo(FilePermission.class.getName(), "./rabbitMQcertificates/*", "read"), new PermissionInfo(SocketPermission.class.getName(), "*:5672", "connect"), new PermissionInfo(SocketPermission.class.getName(), "*:5671", "connect"), new PermissionInfo(SocketPermission.class.getName(), "*:1318", "connect,resolve,listen,accept"), new PermissionInfo(SocketPermission.class.getName(), "*:1319", "connect,resolve,listen,accept"), new PermissionInfo(PackagePermission.class.getName(), "*", "export"), new PermissionInfo(AdminPermission.class.getName(), "*", "metadata"), new PermissionInfo(PropertyPermission.class.getName(), "*", "read"), new PermissionInfo(ConfigurationPermission.class.getName(), "*", "configure,target"), new PermissionInfo(FilePermission.class.getName(), "./keystore/*", "read,write"), new PermissionInfo(FilePermission.class.getName(), "./load", "read,write"), new PermissionInfo(FilePermission.class.getName(), "./load/*", "read,write,delete"), new PermissionInfo(AdminPermission.class.getName(), "*", "metadata"), new PermissionInfo(AdminPermission.class.getName(), "*", "lifecycle"), new PermissionInfo(AdminPermission.class.getName(), "*", "execute"), new PermissionInfo(AdminPermission.class.getName(), "*", "resolve"), new PermissionInfo(AdminPermission.class.getName(), "*", "resource"), new PermissionInfo(PropertyPermission.class.getName(), "*", "read")};
        inf.add(cpa.newConditionalPermissionInfo("ZSE Basis/Core Bundles", new ConditionInfo[]{new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{"*/com.starbase.core*"}), new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{cert})}, corePermissions, "allow"));
        inf.add(cpa.newConditionalPermissionInfo("ZSE Crypto Bundle", new ConditionInfo[]{new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{"*/com.starbase.core.crypto*"}), new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{cert})}, cryptoPermissions, "allow"));
        inf.add(cpa.newConditionalPermissionInfo("ZSE Basis/Mgmt Bundles", new ConditionInfo[]{new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{"*/com.starbase.mgmt*"}), new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{cert})}, corePermissions, "allow"));
        inf.add(cpa.newConditionalPermissionInfo("ZSE Basis/Service Bundles", new ConditionInfo[]{new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{"*/com.starbase.service*"}), new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{cert})}, corePermissions, "allow"));
        inf.add(cpa.newConditionalPermissionInfo("ZSE Application Bundles", new ConditionInfo[]{new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{"*/com.starbase.application*"}), new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{cert})}, applicationPermissions, "allow"));
        inf.add(cpa.newConditionalPermissionInfo("STARBASE Signature", new ConditionInfo[]{new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{cert, "!"})}, new PermissionInfo[]{new PermissionInfo(AllPermission.class.getName(), "*", "*")}, "deny"));
        inf.add(cpa.newConditionalPermissionInfo("deny CPA access", new ConditionInfo[]{new ConditionInfo(BundleLocationCondition.class.getName(), new String[]{"*"})}, new PermissionInfo[]{new PermissionInfo(ServicePermission.class.getName(), "org.osgi.service.condpermadmin.ConditionalPermissionAdmin", "get,register")}, "deny"));
        update.commit();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }
}

