/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.types.starballsports;

import com.starbase.core.types.StarbaseType;
import com.starbase.core.types.starballsports.StarballColorDTO;
import java.util.ArrayList;
import java.util.Random;

public class BallConfigDTO
extends StarbaseType {
    private String id;
    private String name;
    private int speed;
    private int horizontalRealAngle;
    private int horizontalAngle;
    private int verticalRealAngle;
    private int verticalAngle;
    private int spin;
    private boolean engineAdapted = false;
    private double shootDelay = 0.0;
    private Shoot shootBehavior = Shoot.WAIT;
    private BMSoundEffect bmSoundEffect = BMSoundEffect.STANDARD;
    private ArrayList<String> soundList;
    private BMLightEffect bmLightEffect = BMLightEffect.TRAFFICLIGHT;
    private ArrayList<StarballColorDTO> colorList = new ArrayList();
    private int bmLightEffectColor_id;
    private int[] bmLightEffectColor_ids;
    private int bmLightEffect_id;
    private int sound_id;
    private int[] soundList_ids;

    public BallConfigDTO() {
        this.soundList = new ArrayList();
        this.type = BallConfigDTO.class.getName();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getHorizontalAngle() {
        return this.horizontalAngle;
    }

    public int getHorizontalRealAngle() {
        return this.horizontalRealAngle;
    }

    public void setHorizontalRealAngle(int horizontalRealAngle) {
        this.horizontalRealAngle = horizontalRealAngle;
    }

    public int getVerticalRealAngle() {
        return this.verticalRealAngle;
    }

    public void setVerticalRealAngle(int verticalRealAngle) {
        this.verticalRealAngle = verticalRealAngle;
    }

    public void setHorizontalAngle(int horizontalAngle) {
        this.horizontalAngle = horizontalAngle;
    }

    public int getVerticalAngle() {
        return this.verticalAngle;
    }

    public void setVerticalAngle(int verticalAngle) {
        this.verticalAngle = verticalAngle;
    }

    public int getSpin() {
        return this.spin;
    }

    public void setSpin(int spin) {
        this.spin = spin;
    }

    public Shoot getShootBehavior() {
        return this.shootBehavior;
    }

    public void setShootBehavior(Shoot shootBehavior) {
        this.shootBehavior = shootBehavior;
    }

    public boolean isEngineAdapted() {
        return this.engineAdapted;
    }

    public void setEngineAdapted(boolean engineAdapted) {
        this.engineAdapted = engineAdapted;
    }

    public StarballColorDTO firstColor() {
        return this.colorList.get(0);
    }

    public void firstColor(StarballColorDTO color) {
        this.colorList.clear();
        this.colorList.add(0, color);
    }

    public ArrayList<String> getSoundList() {
        return this.soundList;
    }

    public void setSoundList(ArrayList<String> soundList) {
        this.soundList = soundList;
    }

    public StarballColorDTO getRandomColorFromList() {
        if (this.colorList.size() > 0) {
            Random rand = new Random();
            return this.colorList.get(rand.nextInt(this.colorList.size()));
        }
        StarballColorDTO standardColor = new StarballColorDTO();
        standardColor.setSBColor(StarballColorDTO.SBColor.WHITE);
        return standardColor;
    }

    public ArrayList<StarballColorDTO> getColorList() {
        return this.colorList;
    }

    public void setColorList(ArrayList<StarballColorDTO> colorList) {
        this.colorList = colorList;
    }

    public double getShootDelay() {
        return this.shootDelay;
    }

    public int getShootDelayMillis() {
        return (int)(this.shootDelay * 1000.0);
    }

    public void setShootDelay(double shootDelay) {
        this.shootDelay = shootDelay;
    }

    public BMSoundEffect getBmSoundEffect() {
        return this.bmSoundEffect;
    }

    public void setBmSoundEffect(BMSoundEffect bmSoundEffect) {
        this.bmSoundEffect = bmSoundEffect;
    }

    public BMLightEffect getBmLightEffect() {
        return this.bmLightEffect;
    }

    public void setBmLightEffect(BMLightEffect bmLightEffect) {
        this.bmLightEffect = bmLightEffect;
    }

    public int getBmLightEffectColor_id() {
        return this.bmLightEffectColor_id;
    }

    public void setBmLightEffectColor_id(int bmLightEffectColor_id) {
        this.bmLightEffectColor_id = bmLightEffectColor_id;
    }

    public int[] getBmLightEffectColor_ids() {
        return this.bmLightEffectColor_ids;
    }

    public void setBmLightEffectColor_ids(int[] bmLightEffectColor_ids) {
        this.bmLightEffectColor_ids = bmLightEffectColor_ids;
    }

    public int getBmLightEffect_id() {
        return this.bmLightEffect_id;
    }

    public void setBmLightEffect_id(int bmLightEffect_id) {
        this.bmLightEffect_id = bmLightEffect_id;
    }

    public int getSound_id() {
        return this.sound_id;
    }

    public void setSound_id(int sound_id) {
        this.sound_id = sound_id;
    }

    public int[] getSoundList_ids() {
        return this.soundList_ids;
    }

    public void setSoundList_ids(int[] soundList_ids) {
        this.soundList_ids = soundList_ids;
    }

    public static enum BMLightEffect {
        ON,
        OFF,
        BLINK,
        TRAFFICLIGHT,
        INCREASING,
        DECREASING,
        RANDOM,
        LONGRANDOM,
        INDIVIDUAL;

    }

    public static enum BMSoundEffect {
        STANDARD,
        RANDOM,
        LONGRANDOM,
        COUNTDOWN,
        CUSTOM,
        OFF;

    }

    public static enum Shoot {
        DIRECT,
        WAIT;

    }
}

