/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.types.starballsports;

import com.starbase.core.types.StarbaseType;

public class StarballColorDTO
extends StarbaseType {
    public static final int DISABLE_VAL = 60000;
    private int red = 4095;
    private int green = 4095;
    private int blue = 4095;
    private String name = "";
    private int activateLightBarrier = 60000;
    private int activateVibDetection = 60000;
    private SBColor sbColor = SBColor.CUSTOM;

    public StarballColorDTO() {
        this.type = StarballColorDTO.class.getName();
    }

    public StarballColorDTO(SBColor standardColor) {
        this.type = StarballColorDTO.class.getName();
        this.setSBColor(standardColor);
    }

    public SBColor getSBColor() {
        return this.sbColor;
    }

    public void setSBColor(SBColor sbColor) {
        switch (sbColor) {
            case RED: {
                this.red = 4095;
                this.green = 0;
                this.blue = 0;
                this.name = "red";
                break;
            }
            case GREEN: {
                this.red = 0;
                this.green = 4095;
                this.blue = 0;
                this.name = "green";
                break;
            }
            case BLUE: {
                this.red = 0;
                this.green = 0;
                this.blue = 4095;
                this.name = "blue";
                break;
            }
            case YELLOW: {
                this.red = 4095;
                this.green = 4095;
                this.blue = 0;
                this.name = "yellow";
                break;
            }
            case PINK: {
                this.red = 4095;
                this.green = 0;
                this.blue = 4095;
                this.name = "pink";
                break;
            }
            case CYAN: {
                this.red = 0;
                this.green = 4095;
                this.blue = 4095;
                this.name = "cyan";
                break;
            }
            case WHITE: {
                this.red = 4095;
                this.green = 4095;
                this.blue = 4095;
                this.name = "white";
                break;
            }
            case BLACK: {
                this.red = 0;
                this.green = 0;
                this.blue = 0;
                this.name = "black";
                break;
            }
            case ORANGE: {
                this.red = 4095;
                this.green = 3500;
                this.blue = 0;
                this.name = "orange";
                break;
            }
        }
        this.sbColor = sbColor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRed() {
        return this.red;
    }

    public void setRed(int red) {
        this.red = red;
        this.sbColor = this.parseSBColor();
    }

    public int getGreen() {
        return this.green;
    }

    public void setGreen(int green) {
        this.green = green;
        this.sbColor = this.parseSBColor();
    }

    public int getBlue() {
        return this.blue;
    }

    public void setBlue(int blue) {
        this.blue = blue;
        this.sbColor = this.parseSBColor();
    }

    public int getActivateLightBarrier() {
        return this.activateLightBarrier;
    }

    public void setActivateLightBarrier(int activateLightBarrier) {
        this.activateLightBarrier = activateLightBarrier;
    }

    public int getActivateVibDetection() {
        return this.activateVibDetection;
    }

    public void setActivateVibDetection(int activateVibDetection) {
        this.activateVibDetection = activateVibDetection;
    }

    private SBColor parseSBColor() {
        SBColor parsedColor = SBColor.CUSTOM;
        if (this.red == 4095 && this.green == 4095 && this.blue == 4095) {
            parsedColor = SBColor.WHITE;
        } else if (this.red == 4095 && this.green == 4095 && this.blue == 0) {
            parsedColor = SBColor.YELLOW;
        } else if (this.red == 4095 && this.green == 0 && this.blue == 4095) {
            parsedColor = SBColor.PINK;
        } else if (this.red == 4095 && this.green == 4095 && this.blue == 4095) {
            parsedColor = SBColor.WHITE;
        } else if (this.red == 0 && this.green == 4095 && this.blue == 4095) {
            parsedColor = SBColor.CYAN;
        } else if (this.red == 4095 && this.green == 0 && this.blue == 0) {
            parsedColor = SBColor.RED;
        } else if (this.red == 0 && this.green == 4095 && this.blue == 0) {
            parsedColor = SBColor.GREEN;
        } else if (this.red == 0 && this.green == 0 && this.blue == 4095) {
            parsedColor = SBColor.BLUE;
        } else if (this.red == 0 && this.green == 0 && this.blue == 0) {
            parsedColor = SBColor.BLACK;
        }
        return parsedColor;
    }

    public static enum SBColor {
        RED,
        GREEN,
        BLUE,
        YELLOW,
        PINK,
        CYAN,
        WHITE,
        BLACK,
        ORANGE,
        CUSTOM;

    }
}

