/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.types.starbonaut;

import com.starbase.core.types.StarbaseType;
import com.starbase.core.types.starballsports.StarballColorDTO;
import java.util.ArrayList;

public class StarbonautConfigDTO
extends StarbaseType {
    private String playerName;
    private int numberOfBalls;
    private int ballSpeed;
    private double cycleDuration;
    private double orientationTime = 0.5;
    private int activeGoals = 1;
    private ArrayList<StarballColorDTO> colors;
    private ArrayList<String> sounds;
    private GoalSelection goalSelection = GoalSelection.MODERATE;
    private GoalColor goalColor = GoalColor.STANDARD;
    private Mode mode = Mode.LOW;
    private BMSelect bmSelect = BMSelect.RANDOM;

    public static StarbonautConfigDTO createStarbonautConfig(String playerName, int numberOfBalls, int ballSpeed, double cycleDuration, double orientationTime, int activeGoals, GoalSelection goalSelection, GoalColor goalColor, Mode mode, BMSelect bmSelect) {
        StarbonautConfigDTO starbonautConfig = new StarbonautConfigDTO();
        starbonautConfig.setPlayerName(playerName);
        starbonautConfig.setNumberOfBalls(numberOfBalls);
        starbonautConfig.setBallSpeed(ballSpeed);
        starbonautConfig.setCycleDuration(cycleDuration);
        starbonautConfig.setOrientationTime(orientationTime);
        starbonautConfig.setGoalSelection(goalSelection);
        starbonautConfig.setGoalColor(goalColor);
        starbonautConfig.setMode(mode);
        starbonautConfig.setBmSelect(bmSelect);
        starbonautConfig.setActiveGoals(activeGoals);
        return starbonautConfig;
    }

    public StarbonautConfigDTO() {
        this.type = StarbonautConfigDTO.class.getName();
        this.colors = new ArrayList();
        this.sounds = new ArrayList();
    }

    public ArrayList<StarballColorDTO> getColors() {
        return this.colors;
    }

    public void setColors(ArrayList<StarballColorDTO> colors) {
        this.colors = colors;
    }

    public void addColor(StarballColorDTO standardColor) {
        this.colors.add(standardColor);
    }

    public void removeColors() {
        this.colors.clear();
    }

    public ArrayList<String> getSounds() {
        return this.sounds;
    }

    public void setSounds(ArrayList<String> sounds) {
        this.sounds = sounds;
    }

    public void addSound(String sound) {
        this.sounds.add(sound);
    }

    public void removeSounds() {
        this.sounds.clear();
    }

    public int getNumberOfBalls() {
        return this.numberOfBalls;
    }

    public void setNumberOfBalls(int numberOfBalls) {
        this.numberOfBalls = numberOfBalls;
    }

    public int getBallSpeed() {
        return this.ballSpeed;
    }

    public void setBallSpeed(int ballSpeed) {
        this.ballSpeed = ballSpeed;
    }

    public double getCycleDuration() {
        return this.cycleDuration;
    }

    public void setCycleDuration(double cycleDuration) {
        this.cycleDuration = cycleDuration;
    }

    public double getOrientationTime() {
        return this.orientationTime;
    }

    public void setOrientationTime(double orientationTime) {
        this.orientationTime = orientationTime;
    }

    public int getActiveGoals() {
        return this.activeGoals;
    }

    public void setActiveGoals(int activeGoals) {
        this.activeGoals = activeGoals;
    }

    public GoalSelection getGoalSelection() {
        return this.goalSelection;
    }

    public void setGoalSelection(GoalSelection goalSelection) {
        this.goalSelection = goalSelection;
    }

    public GoalColor getGoalColor() {
        return this.goalColor;
    }

    public void setGoalColor(GoalColor goalColor) {
        this.goalColor = goalColor;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public BMSelect getBmSelect() {
        return this.bmSelect;
    }

    public void setBmSelect(BMSelect bmSelect) {
        this.bmSelect = bmSelect;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public static enum BMSelect {
        RANDOM,
        ALTERNATE,
        SINGLE;

    }

    public static enum Mode {
        LOW,
        RANDOM,
        GOALKEEPER,
        CHIP,
        MANUAL,
        PLAYLIST;

    }

    public static enum GoalColor {
        STANDARD,
        SINGLECOLOR,
        MULTICOLOR;

    }

    public static enum GoalSelection {
        SIMPLE,
        MODERATE,
        DIFFICULT,
        FRONT,
        BACK;

    }
}

