/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.webserver;

import com.starbase.core.auth.api.AuthService;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.webserver.api.HTTPService;
import com.starbase.core.webserver.api.HTTPServiceRedirect;
import com.starbase.core.webserver.impl.HTTPServiceProviderImpl;
import com.starbase.core.webserver.impl.HTTPServiceTracker;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private ServiceTracker<HTTPService, HTTPService> httpServiceTracker;
    private static ServiceTracker<AuthService, AuthService> authServiceTracker;
    private static LogServiceTracker logServiceTracker;

    public static LogService getLog() {
        return logServiceTracker == null ? null : logServiceTracker.getService();
    }

    public static AuthService getAuth() {
        return authServiceTracker == null ? null : (AuthService)authServiceTracker.getService();
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        authServiceTracker = new ServiceTracker<AuthService, AuthService>(bundleContext, AuthService.class, null){};
        authServiceTracker.open();
        HTTPServiceProviderImpl provider = new HTTPServiceProviderImpl();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("type", "JSON");
        context.registerService(MappingServiceAware.class, (Object)provider, properties);
        ((Dictionary)properties).remove("type");
        this.httpServiceTracker = new HTTPServiceTracker(bundleContext, provider);
        this.httpServiceTracker.open();
        ((Dictionary)properties).put("path", "/");
        context.registerService(HTTPService.class, (Object)new HTTPServiceRedirect(){

            public String getRedirectPath() {
                return "/starbase/ui/index.html";
            }
        }, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.httpServiceTracker.close();
        authServiceTracker.close();
        logServiceTracker.close();
        context = null;
    }
}

