/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.webserver.impl;

import com.starbase.core.auth.api.AuthService;
import com.starbase.core.auth.dto.UserDTO;
import com.starbase.core.webserver.Activator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class HTTPContextFactory {
    private static HttpContext defaultContext;
    private static HttpContext authContext;

    public static HttpContext getContext(boolean authRequired) {
        HTTPContextFactory.createContext();
        if (authRequired) {
            return authContext;
        }
        return defaultContext;
    }

    public static void createContext() {
        if (defaultContext == null) {
            defaultContext = HTTPContextFactory.createDefaultContext();
        }
        if (authContext == null) {
            authContext = HTTPContextFactory.createAuthContext();
        }
    }

    private static HttpContext createAuthContext() {
        return new HttpContext(){

            public boolean handleSecurity(HttpServletRequest req, HttpServletResponse res) throws IOException {
                if (req.getHeader("Authorization") == null) {
                    res.addHeader("WWW-Authenticate", "Basic realm=\"STARBASE Restricted Area\"");
                    res.sendError(401);
                    return false;
                }
                if (this.authenticated(req)) {
                    return true;
                }
                res.sendError(401);
                return false;
            }

            private boolean authenticated(HttpServletRequest request) {
                try {
                    String authContent = request.getHeader("Authorization");
                    String basicAuthPrefix = "Basic ";
                    if (!authContent.startsWith(basicAuthPrefix)) {
                        return false;
                    }
                    authContent = authContent.replaceFirst(basicAuthPrefix, "");
                    request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                    String authString = new String(Base64.getDecoder().decode(authContent.getBytes()));
                    String[] up = authString.split(":");
                    AuthService authService = Activator.getAuth();
                    if (authService == null) {
                        Activator.getLog().log(1, "Auth Service is null, all requests requiring authentication will be denied");
                        return false;
                    }
                    UserDTO currentUser = authService.authenticate(up[0], up[1]);
                    if (currentUser == null) {
                        Activator.getLog().log(2, "user not found");
                        return false;
                    }
                    if (authService.authorize(currentUser)) {
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)currentUser.getName());
                        return true;
                    }
                    return false;
                }
                catch (Throwable e) {
                    Activator.getLog().log(1, "error in authentication method", e);
                    return false;
                }
            }

            public URL getResource(String name) {
                URL res = HTTPContextFactory.getBundleResource(name);
                if (res != null) {
                    return res;
                }
                try {
                    File file = new File(name);
                    if (file.isDirectory()) {
                        file = new File(name + "/index.html");
                    }
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }

            public String getMimeType(String name) {
                return null;
            }
        };
    }

    private static URL getBundleResource(String name) {
        try {
            if (name.startsWith("bundle")) {
                URL res;
                String tmp = name;
                int slashIndex = name.indexOf("/");
                if (slashIndex >= 0) {
                    tmp = tmp.substring(0, slashIndex);
                }
                tmp = tmp.replaceFirst("bundle", "");
                long bundleId = Long.valueOf(tmp);
                Bundle bundle = Activator.getContext().getBundle(bundleId);
                tmp = name.replaceFirst("bundle" + bundleId, "");
                if (tmp.startsWith("/")) {
                    tmp = tmp.replaceFirst("/", "");
                }
                if ((res = bundle.getEntry("/resources/" + tmp)) == null || tmp.isEmpty()) {
                    res = bundle.getEntry("/resources/index.html");
                }
                return res;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static HttpContext createDefaultContext() {
        return new HttpContext(){

            public boolean handleSecurity(HttpServletRequest req, HttpServletResponse res) throws IOException {
                return true;
            }

            public URL getResource(String name) {
                URL res = HTTPContextFactory.getBundleResource(name);
                if (res != null) {
                    return res;
                }
                try {
                    File file = new File(name);
                    if (file.isDirectory()) {
                        file = new File(name + "/index.html");
                    }
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public String getMimeType(String name) {
                return null;
            }
        };
    }
}

