/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.webserver.impl;

import com.starbase.core.exception.StarbaseException;
import com.starbase.core.exception.general.BadFormatException;
import com.starbase.core.exception.general.BadRequestException;
import com.starbase.core.exception.general.ClassNotFoundException;
import com.starbase.core.exception.general.NotFoundException;
import com.starbase.core.exception.general.NotImplementedException;
import com.starbase.core.exception.security.AuthenticationFailedException;
import com.starbase.core.exception.security.ForbiddenException;
import com.starbase.core.exception.security.UnauthorizedException;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.webserver.Activator;
import com.starbase.core.webserver.api.HTTPService;
import com.starbase.core.webserver.api.HTTPServiceProvider;
import com.starbase.core.webserver.api.HTTPServiceRedirect;
import com.starbase.core.webserver.api.HTTPServiceResource;
import com.starbase.core.webserver.api.JSONServiceDELETE;
import com.starbase.core.webserver.api.JSONServiceGET;
import com.starbase.core.webserver.api.JSONServicePOST;
import com.starbase.core.webserver.api.JSONServicePUT;
import com.starbase.core.webserver.api.JSONUpdatable;
import com.starbase.core.webserver.impl.HTTPContextFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class HTTPServiceProviderImpl
implements HTTPServiceProvider,
MappingServiceAware {
    private HashMap<HTTPService, ServiceTracker<HttpService, HttpService>> trackerList = new HashMap();
    private MappingService mappingService;

    public void addService(final HTTPService sv, final String path, final boolean authRequired) {
        final HttpServlet servlet = this.createServlet(sv);
        ServiceTracker<HttpService, HttpService> httpTracker = new ServiceTracker<HttpService, HttpService>(Activator.getContext(), HttpService.class, null){

            public void removedService(ServiceReference<HttpService> reference, HttpService service) {
                try {
                    service.unregister(path);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            public HttpService addingService(ServiceReference<HttpService> reference) {
                HttpService httpService = (HttpService)this.context.getService(reference);
                try {
                    if (sv instanceof HTTPServiceResource) {
                        HTTPServiceResource res = (HTTPServiceResource)sv;
                        httpService.registerResources(path, res.getLocalPath(), HTTPContextFactory.getContext(authRequired));
                        Activator.getLog().log(3, "register static resource " + path + " - " + res.getLocalPath() + " Auth: " + authRequired);
                    } else {
                        httpService.registerServlet(path, (Servlet)servlet, null, HTTPContextFactory.getContext(authRequired));
                        Activator.getLog().log(3, "register servlet via " + path + " Auth: " + authRequired);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return httpService;
            }
        };
        httpTracker.open();
        this.trackerList.put(sv, httpTracker);
    }

    private HttpServlet createServlet(final HTTPService sv) {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                if (sv instanceof HTTPServiceRedirect) {
                    HTTPServiceRedirect redirect = (HTTPServiceRedirect)sv;
                    String forwardPath = redirect.getRedirectPath();
                    resp.sendRedirect(forwardPath);
                    return;
                }
                this.addAccessControlHeaders(resp);
                if (sv instanceof JSONServiceGET) {
                    JSONServiceGET svc = (JSONServiceGET)sv;
                    HashMap params = HTTPServiceProviderImpl.generateParamsMapFromRequest(req);
                    try {
                        resp.getWriter().write(svc.get((Map)params, this.getRequestUriExtension(req)).toString());
                        resp.setContentType("application/json");
                        resp.setStatus(200);
                    }
                    catch (Exception e) {
                        this.handleException(req, resp, e);
                    }
                } else {
                    this.handleException(req, resp, (Exception)new NotImplementedException());
                }
            }

            protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                this.addAccessControlHeaders(resp);
                if (sv instanceof JSONServiceDELETE) {
                    JSONServiceDELETE svc = (JSONServiceDELETE)sv;
                    HashMap params = HTTPServiceProviderImpl.generateParamsMapFromRequest(req);
                    try {
                        svc.delete((Map)params, this.getRequestUriExtension(req));
                        resp.setStatus(200);
                    }
                    catch (Exception e) {
                        this.handleException(req, resp, e);
                    }
                } else {
                    this.handleException(req, resp, (Exception)new ClassNotFoundException());
                }
            }

            protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                super.doOptions(req, resp);
                this.addAccessControlHeaders(resp);
            }

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                this.addAccessControlHeaders(resp);
                if (sv instanceof JSONServicePOST) {
                    JSONServicePOST svc = (JSONServicePOST)sv;
                    HashMap params = HTTPServiceProviderImpl.generateParamsMapFromRequest(req);
                    try {
                        String bodyFromRequest = HTTPServiceProviderImpl.getBodyFromRequest(req);
                        String response = "";
                        resp.addHeader("Content-Type", "application/json");
                        if (svc.getType() == String.class) {
                            response = svc.post((Object)bodyFromRequest, (Map)params, this.getRequestUriExtension(req)).toString();
                        } else if (svc instanceof JSONUpdatable) {
                            JSONUpdatable upd = (JSONUpdatable)svc;
                            Object updatableObject = upd.getUpdatableObject((Map)params, this.getRequestUriExtension(req));
                            updatableObject = HTTPServiceProviderImpl.this.mappingService.mergeObject(bodyFromRequest, updatableObject);
                            response = HTTPServiceProviderImpl.this.mappingService.mapToString(svc.post(updatableObject, (Map)params, this.getRequestUriExtension(req)));
                        } else {
                            Object o = HTTPServiceProviderImpl.this.mappingService.mapToObject(bodyFromRequest, svc.getType());
                            response = HTTPServiceProviderImpl.this.mappingService.mapToString(svc.post(svc.getType().cast(o), (Map)params, this.getRequestUriExtension(req)));
                        }
                        resp.getWriter().write(response);
                        resp.setStatus(200);
                    }
                    catch (Exception e) {
                        this.handleException(req, resp, e);
                    }
                } else {
                    this.handleException(req, resp, (Exception)new ClassNotFoundException());
                }
            }

            protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                this.addAccessControlHeaders(resp);
                if (sv instanceof JSONServicePUT) {
                    JSONServicePUT svc = (JSONServicePUT)sv;
                    HashMap params = HTTPServiceProviderImpl.generateParamsMapFromRequest(req);
                    try {
                        String bodyFromRequest = HTTPServiceProviderImpl.getBodyFromRequest(req);
                        String response = "";
                        resp.addHeader("Content-Type", "application/json");
                        if (svc.getType() == String.class) {
                            response = svc.put((Object)bodyFromRequest, (Map)params, this.getRequestUriExtension(req)).toString();
                        } else if (svc instanceof JSONUpdatable) {
                            JSONUpdatable upd = (JSONUpdatable)svc;
                            Object updatableObject = upd.getUpdatableObject((Map)params, this.getRequestUriExtension(req));
                            updatableObject = HTTPServiceProviderImpl.this.mappingService.mergeObject(bodyFromRequest, updatableObject);
                            response = HTTPServiceProviderImpl.this.mappingService.mapToString(svc.put(updatableObject, (Map)params, this.getRequestUriExtension(req)));
                        } else {
                            Object o = HTTPServiceProviderImpl.this.mappingService.mapToObject(bodyFromRequest, svc.getType());
                            response = HTTPServiceProviderImpl.this.mappingService.mapToString(svc.put(svc.getType().cast(o), (Map)params, this.getRequestUriExtension(req)));
                        }
                        resp.getWriter().write(response);
                        resp.setStatus(200);
                    }
                    catch (Exception e) {
                        this.handleException(req, resp, e);
                    }
                } else {
                    this.handleException(req, resp, (Exception)new ClassNotFoundException());
                }
            }

            public void log(String message, Throwable t) {
                Activator.getLog().log(3, message, t);
            }

            public void log(String msg) {
                Activator.getLog().log(3, msg);
            }

            private void handleException(HttpServletRequest req, HttpServletResponse resp, Exception ex) throws IOException {
                try {
                    throw ex;
                }
                catch (NotFoundException e) {
                    Activator.getLog().log(4, ((Object)((Object)e)).getClass().getSimpleName() + " from " + req.getLocalName() + ", requested uri: " + req.getRequestURI());
                    resp.setStatus(404);
                    resp.getWriter().write("not found");
                }
                catch (BadFormatException | BadRequestException e) {
                    Activator.getLog().log(4, e.getClass().getSimpleName() + " from " + req.getLocalName() + ", requested uri: " + req.getRequestURI());
                    resp.setStatus(400);
                    resp.getWriter().write("bad request");
                }
                catch (ForbiddenException | SecurityException e) {
                    Activator.getLog().log(3, e.getClass().getSimpleName() + " from " + req.getLocalName() + ", requested uri: " + req.getRequestURI());
                    resp.setStatus(403);
                    resp.getWriter().write("forbidden");
                }
                catch (ClassNotFoundException | NotImplementedException e) {
                    Activator.getLog().log(4, e.getClass().getSimpleName() + " from " + req.getLocalName() + ", requested uri: " + req.getRequestURI());
                    this.addAccessControlHeaders(resp);
                    resp.setStatus(405);
                    resp.getWriter().write("method not allowed");
                }
                catch (AuthenticationFailedException | UnauthorizedException e) {
                    Activator.getLog().log(4, e.getClass().getSimpleName() + " from " + req.getLocalName() + ", requested uri: " + req.getRequestURI());
                    resp.setStatus(401);
                    resp.getWriter().write("unauthorized");
                }
                catch (StarbaseException e) {
                    Activator.getLog().log(3, ((Object)((Object)e)).getClass().getSimpleName() + " from " + req.getLocalName() + ", requested uri: " + req.getRequestURI(), (Throwable)e);
                    resp.setStatus(500);
                    resp.getWriter().write("internal server error");
                }
                catch (Exception e) {
                    Activator.getLog().log(2, e.getClass().getSimpleName() + " from " + req.getLocalName() + ", requested uri: " + req.getRequestURI(), (Throwable)e);
                    resp.setStatus(500);
                    resp.getWriter().write("internal server error");
                }
            }

            private String getRequestUriExtension(HttpServletRequest req) {
                String uri = req.getRequestURI();
                if ((uri = uri.replaceFirst(req.getServletPath(), "")).startsWith("/")) {
                    uri = uri.replaceFirst("/", "");
                }
                return uri;
            }

            private void addAccessControlHeaders(HttpServletResponse resp) {
                StringBuilder methods = new StringBuilder();
                if (sv instanceof JSONServiceGET) {
                    methods.append("GET, ");
                }
                if (sv instanceof JSONServicePOST) {
                    methods.append("POST, ");
                }
                if (sv instanceof JSONServiceDELETE) {
                    methods.append("DELETE, ");
                }
                if (sv instanceof JSONServicePUT) {
                    methods.append("PUT, ");
                }
                resp.addHeader("Access-Control-Allow-Origin", "*");
                resp.addHeader("Access-Control-Allow-Methods", methods.toString() + "OPTIONS");
                resp.addHeader("Access-Control-Allow-Headers", "X-Requested-With, Content-Type, X-Codingpedia, Authorization, origin");
                resp.addHeader("Access-Control-Allow-Credentials", "true");
            }
        };
        return servlet;
    }

    public void removeService(HTTPService sv) {
        this.trackerList.remove(sv).close();
    }

    public void close() {
        for (Map.Entry<HTTPService, ServiceTracker<HttpService, HttpService>> serviceTrackerEntry : this.trackerList.entrySet()) {
            serviceTrackerEntry.getValue().close();
        }
    }

    private static HashMap<String, String> generateParamsMapFromRequest(HttpServletRequest req) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String paramName : Collections.list(req.getParameterNames())) {
            params.put(paramName, req.getParameter(paramName));
        }
        return params;
    }

    private static String getBodyFromRequest(HttpServletRequest req) throws Exception {
        StringBuffer jb = new StringBuffer();
        String line = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (Exception e) {
            Activator.getLog().log(4, "IncReq: " + jb.toString());
            throw new BadRequestException("Error while reading request body", (Throwable)e);
        }
        return jb.toString();
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }
}

