/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.core.webserver.impl;

import com.starbase.core.webserver.Activator;
import com.starbase.core.webserver.api.HTTPService;
import com.starbase.core.webserver.api.HTTPServiceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class HTTPServiceTracker
extends ServiceTracker<HTTPService, HTTPService> {
    private HTTPServiceProvider provider;

    public HTTPServiceTracker(BundleContext context, HTTPServiceProvider provider) {
        super(context, HTTPService.class, null);
        this.provider = provider;
        Activator.getLog().log(3, "HTTPServiceTracker started");
    }

    public HTTPService addingService(ServiceReference<HTTPService> reference) {
        HTTPService sv = (HTTPService)super.addingService(reference);
        boolean authRequired = false;
        try {
            authRequired = Boolean.valueOf(reference.getProperty("auth").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String path = reference.getProperty("path").toString();
            this.provider.addService(sv, path, authRequired);
        }
        catch (Exception e) {
            Activator.getLog().log(1, "unable to add new http service due to wrong defined propertes (required: path) in bundle " + reference.getBundle().getSymbolicName());
        }
        return sv;
    }

    public void removedService(ServiceReference<HTTPService> reference, HTTPService service) {
        try {
            String path = reference.getProperty("path").toString();
            this.provider.removeService(service);
            Activator.getLog().log(3, "removed http service " + path);
        }
        catch (Exception e) {
            Activator.getLog().log(1, "unable to remove http service due to wrong defined propertes (required: path) in bundle " + reference.getBundle().getSymbolicName());
        }
        super.removedService(reference, (Object)service);
    }
}

