/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.mgmt.modules;

import com.starbase.core.communication.api.CommunicationServicesAware;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.core.webserver.api.HTTPService;
import com.starbase.mgmt.modules.ModuleWS;
import com.starbase.mgmt.modules.update.ManualEventWS;
import com.starbase.mgmt.modules.update.Timer;
import com.starbase.mgmt.modules.update.UpdateWS;
import com.starbase.mgmt.modules.update.Updater;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;

    public static BundleContext getContext() {
        return context;
    }

    public static LogService getLog() {
        return logServiceTracker == null ? null : logServiceTracker.getService();
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("path", "/starbase/module");
        ((Dictionary)properties).put("auth", "true");
        ModuleWS ws = new ModuleWS();
        context.registerService(HTTPService.class, (Object)ws, properties);
        context.registerService(MappingServiceAware.class, (Object)ws, null);
        Updater updateService = new Updater();
        ((Dictionary)properties).put("path", "/starbase/message");
        ((Dictionary)properties).put("auth", "true");
        context.registerService(new String[]{HTTPService.class.getName(), MessagingServiceAware.class.getName()}, (Object)new ManualEventWS(), properties);
        ((Dictionary)properties).remove("path");
        ((Dictionary)properties).remove("auth");
        ((Dictionary)properties).put("path", "/starbase/update");
        ((Dictionary)properties).put("auth", "true");
        context.registerService(new String[]{HTTPService.class.getName(), MappingServiceAware.class.getName()}, (Object)new UpdateWS(updateService), properties);
        ((Dictionary)properties).remove("path");
        ((Dictionary)properties).remove("auth");
        ((Dictionary)properties).put("topic", new String[]{"in.http.starbase-framework", "in.http.starbase-applications"});
        ((Dictionary)properties).put("services", new String[]{"com.starbase.service.io.http"});
        context.registerService(new String[]{MappingServiceAware.class.getName(), CommunicationServicesAware.class.getName(), MessageConsumer.class.getName()}, (Object)updateService, properties);
        ((Dictionary)properties).put("topic", new String[]{"timer.hourly", "custom.repository.update"});
        context.registerService(new String[]{MessageConsumer.class.getName()}, (Object)new Timer(updateService), properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        logServiceTracker.close();
        context = null;
    }
}

