/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.mgmt.modules;

import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.webserver.api.JSONServiceGET;
import com.starbase.core.webserver.api.JSONServicePOST;
import com.starbase.mgmt.modules.Activator;
import com.starbase.mgmt.modules.CommandDTO;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.Bundle;

public class ModuleWS
implements JSONServiceGET,
JSONServicePOST<String>,
MappingServiceAware {
    private MappingService mappingService;

    private String stateToString(int state) {
        return State.getState(state).name();
    }

    public Object get(Map<String, String> params, String uri) throws Exception {
        ArrayList bundleList = new ArrayList();
        for (Bundle bundle : Activator.getContext().getBundles()) {
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            ht.put("bundleId", bundle.getBundleId());
            ht.put("bundleName", bundle.getSymbolicName());
            ht.put("state", this.stateToString(bundle.getState()));
            bundleList.add(ht);
        }
        return this.mappingService.mapToString(bundleList);
    }

    public Class<String> getType() {
        return String.class;
    }

    public String post(Object object, Map<String, String> params, String uri) throws Exception {
        CommandDTO cmd = (CommandDTO)this.mappingService.mapToObject(object.toString(), CommandDTO.class);
        if (cmd.command.equalsIgnoreCase("update")) {
            Bundle bundle = Activator.getContext().getBundle(cmd.bundleId);
            bundle.update();
        } else if (cmd.command.equalsIgnoreCase("start")) {
            Bundle bundle = Activator.getContext().getBundle(cmd.bundleId);
            bundle.start();
        } else if (cmd.command.equalsIgnoreCase("stop")) {
            Bundle bundle = Activator.getContext().getBundle(cmd.bundleId);
            bundle.stop();
        } else if (cmd.command.equalsIgnoreCase("uninstall")) {
            Bundle bundle = Activator.getContext().getBundle(cmd.bundleId);
            bundle.uninstall();
            Activator.getLog().log(3, "uninstalling " + bundle.getLocation());
        }
        return object.toString();
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }

    static enum State {
        ACTIVE(32),
        INSTALLED(2),
        RESOLVED(4),
        STARTING(8),
        STOPPING(16),
        UNINSTALLED(1),
        UNKNOWN(20);

        private final int stateNum;

        private State(int state) {
            this.stateNum = state;
        }

        public int getStateNum() {
            return this.stateNum;
        }

        public static State getState(int id) {
            for (State state : State.values()) {
                if (state.getStateNum() != id) continue;
                return state;
            }
            return UNKNOWN;
        }
    }
}

