/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.mgmt.modules.update;

public class RepositoryEntryDTO
implements Comparable<RepositoryEntryDTO> {
    private static final String SEP = "-";
    private static final String SNAPSHOT = "-SNAPSHOT";
    private String name;
    private String version;
    private String url;

    public RepositoryEntryDTO setUrl(String fileName) {
        this.url = fileName;
        String[] filePathParts = fileName.split("/");
        fileName = filePathParts[filePathParts.length - 1];
        String[] sp = (fileName = fileName.replace(".jar", "")).split(SEP, 2);
        if (sp.length >= 2) {
            this.name = sp[0];
            this.version = sp[1];
        }
        return this;
    }

    public boolean equals(Object obj) {
        return this.name.equals(obj.toString());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(RepositoryEntryDTO o) {
        if (this.version.equals(o.getVersion())) {
            return 0;
        }
        String vA = this.version.replace(SNAPSHOT, "");
        String[] nrA = vA.split(".");
        String vB = o.getVersion().replace(SNAPSHOT, "");
        String[] nrB = vB.split(".");
        for (int i = 0; i < nrA.length; ++i) {
            Integer ia = Integer.valueOf(nrA[i]);
            Integer ib = Integer.valueOf(nrB[i]);
            if (ia > ib) {
                return 1;
            }
            if (ia >= ib) continue;
            return -1;
        }
        if (this.version.contains(SNAPSHOT)) {
            return 1;
        }
        if (o.getVersion().contains(SNAPSHOT)) {
            return -1;
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public RepositoryEntryDTO setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public RepositoryEntryDTO setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getUrl() {
        return this.url;
    }
}

