/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.mgmt.modules.update;

import com.starbase.core.DTOFactory;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.api.CommunicationServicesAware;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.mgmt.modules.Activator;
import com.starbase.mgmt.modules.update.RepositoryEntryDTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Updater
implements MappingServiceAware,
CommunicationServicesAware,
MessageConsumer {
    private MappingService mappingService;
    private Map<String, CommunicationService> serviceArray;
    private Map<String, String> repositories = new Hashtable<String, String>();
    private Map<String, List<RepositoryEntryDTO>> repoData;

    public Updater() {
        this.repositories.put("starbase-framework", "https://repo.starballsports.com:443/SNAPSHOT/starbase.json");
        this.repoData = new Hashtable<String, List<RepositoryEntryDTO>>();
    }

    public void update() {
        ArrayList<RepositoryEntryDTO> local = new ArrayList<RepositoryEntryDTO>();
        for (Bundle bundle : Activator.getContext().getBundles()) {
            RepositoryEntryDTO entry = new RepositoryEntryDTO().setUrl(bundle.getLocation()).setName(bundle.getSymbolicName()).setVersion(bundle.getVersion().toString());
            local.add(entry);
        }
        this.repoData.put("local", local);
        if (this.serviceArray == null) {
            Activator.getLog().log(2, "CommuncationServices not injected");
            return;
        }
        CommunicationService httpService = this.serviceArray.get("com.starbase.service.io.http");
        if (httpService == null) {
            Activator.getLog().log(2, "no http service");
            return;
        }
        for (Map.Entry<String, String> entry : this.repositories.entrySet()) {
            httpService.sendMessage(new AddressDTO().setTo(entry.getValue()), DTOFactory.createEvent((String)"", (String)entry.getKey(), (String)"update", (CipherMode)CipherMode.PLAIN, (String)entry.getValue()));
        }
    }

    public void push(EventDTO event, String topic) {
        String data = event.getBody();
        RepositoryEntryDTO[] entries = null;
        try {
            if (data.contains("404 Not Found")) {
                Activator.getLog().log(2, "Repo not found error 404 from: " + event.getFrom());
            }
            entries = (RepositoryEntryDTO[])this.mappingService.mapToObject(data, RepositoryEntryDTO[].class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<RepositoryEntryDTO> entr = new ArrayList<RepositoryEntryDTO>();
        for (RepositoryEntryDTO repositoryEntryDTO : entries) {
            entr.add(repositoryEntryDTO);
        }
        this.repoData.put(event.getFrom(), entr);
    }

    public void updateBundle(RepositoryEntryDTO entry) throws IOException, Exception {
        String remoteFileName = entry.getUrl();
        BundleContext context = Activator.getContext();
        Bundle oldBundle = context.getBundle(remoteFileName);
        if (oldBundle != null) {
            oldBundle.uninstall();
        } else {
            oldBundle = context.getBundle(this.getBundleLocationFromBundleURI(remoteFileName));
            if (oldBundle != null) {
                oldBundle.uninstall();
            }
        }
        Bundle installedBundle = context.installBundle(remoteFileName);
        if (installedBundle != null) {
            installedBundle.start();
        }
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
        if (this.serviceArray != null && this.mappingService != null) {
            this.update();
        }
    }

    public void setCommunicationService(Map<String, CommunicationService> serviceArray) {
        this.serviceArray = serviceArray;
        if (this.mappingService != null && this.serviceArray != null) {
            this.update();
        }
    }

    public Map<String, List<RepositoryEntryDTO>> getRepoData() {
        return this.repoData;
    }

    private String getBundleLocationFromBundleURI(String uri) {
        String[] uriSplit = uri.split("/");
        String bundleName = uriSplit[uriSplit.length - 1].split("-")[0];
        for (RepositoryEntryDTO repo : this.repoData.get("local")) {
            if (!repo.getName().equals(bundleName)) continue;
            return repo.getUrl();
        }
        return "";
    }
}

