(function() {

  var module = angular.module("STARBASE", ["ngRoute",'ngResource']);

  module.config(function($routeProvider) {
    
    $routeProvider
      .when("/main", {
        templateUrl: "html/main.html",
        controller: "MainController"
      })
      .when("/config", {
        templateUrl: "html/config_list.html",
        controller: "ConfigController"
      })
      .when("/config/:pid", {
        templateUrl: "html/config_update.html",
        controller: "ConfigUpdateController"
      })
      .when("/address", {
    	  templateUrl: "html/address_list.html",
    	  controller: "AddressController"
      })
      .when("/address/:pid", {
    	  templateUrl: "html/address_update.html",
    	  controller: "AddressUpdateController"
      })
      .when("/module", {
    	  templateUrl: "html/module_list.html",
    	  controller: "ModuleController"
      })
      .when("/repository", {
    	  templateUrl: "html/repository.html",
    	  controller: "RepositoryController"
      })
      .when("/accessviolations", {
    	  templateUrl: "html/accessviolations.html",
    	  controller: "AccessViolationsController"
      })
      .when("/module/:pid", {
    	  templateUrl: "html/permission_update.html",
    	  controller: "PermissionUpdateController"
      })
      .otherwise({redirectTo:"/main"});

  });

}());
