(function() {

	var application = angular.module('STARBASE');

	var MainController = function($scope, configManagement, moduleManagement, addressManagement) {
		var c = configManagement.list.query(function() {
			$scope.c = c;
		});
		var m = moduleManagement.list.query(function() {
			$scope.m = m;
		});
		var a = addressManagement.list.query(function() {
			$scope.a = Object.keys(a).length - 2;
		});

	};

	var ConfigController = function($scope, $routeParams, configManagement) {
		var e = configManagement.list.query(function() {
			$scope.configlist = e;
		});
	};

	var ConfigUpdateController = function($scope, $routeParams, configManagement) {
		$scope.pid = $routeParams.pid;
		var e = configManagement.detail.query({
			pid : $routeParams.pid
		});
		$scope.configuration = e;

		$scope.addnew = function(key) {
			$scope.configuration[key] = "";
		};

		$scope.update = function() {
			e.$save({
				pid : $routeParams.pid
			}, function() {
				$scope.success = true;
			}, function(error) {
				$scope.error = error.status + " " + error.statusText;
			});
		};
	};

	var AccessViolationsController = function($scope, $routeParams, accessViolationManagement) {
		var e = accessViolationManagement.list.query(function() {
			$scope.access = e;
		});
	};
	
	var PermissionUpdateController = function($scope, $routeParams, permissionManagement) {
		$scope.pid = $routeParams.pid;
		var e = permissionManagement.detail.query({
			pid : $routeParams.pid
		});
		$scope.permission = e;

		$scope.newkey = "com.starbase.service.";
		if($routeParams.newService != undefined) {
			$scope.newkey = $routeParams.newService;
		}
		$scope.topic = "io.*";
		if($routeParams.newTopic != undefined) {
			$scope.topic = $routeParams.newTopic;
		}
		
		$scope.addcommservice = function(key) {
			if (!(key == undefined)) {
				if ($scope.permission.communicationPermissions == undefined) {
					$scope.permission.communicationPermissions = [];
				}
				$scope.permission.communicationPermissions.push({
					"servicePid" : key
				});
			}
		};
		$scope.addmessaging = function(key) {
			if (!(key == undefined)) {
				if ($scope.permission.messagingPermissions == undefined) {
					$scope.permission.messagingPermissions = [];
				}
				$scope.permission.messagingPermissions.push({
					"topic" : key,
					"accessLevel" : 1
				});
			}
		};

		$scope.update = function() {
			e.$save({
				pid : $routeParams.pid
			}, function() {
				$scope.success = true;
			}, function(error) {
				$scope.error = error.status + " " + error.statusText;
			});
		};
	};

	var AddressController = function($scope, $routeParams, addressManagement) {
		var e = addressManagement.list.query(function() {
			$scope.addresslist = e;
			delete e.$promise;
			delete e.$resolved;
			$scope.addresskeys = Object.keys($scope.addresslist);
		});
		$scope.success = undefined;
		$scope.remove = function(key) {
			var f = addressManagement.remove.query({
				k : key
			}, function() {
				$scope.success = true;
				e[key] = undefined;
			}, function(error) {
				$scope.success = undefined;
				$scope.error = error.status + " " + error.statusText;
			});
		};
	};

	var AddressUpdateController = function($scope, $routeParams, addressManagement) {
		$scope.pid = $routeParams.pid;
		var e = addressManagement.detail.query({
			pid : $routeParams.pid
		});
		$scope.address = e;

		$scope.update = function() {
			e.$save({
				pid : $routeParams.pid
			}, function() {
				$scope.success = true;
			}, function(error) {
				$scope.error = error.status + " " + error.statusText;
			});
		};
	};

	var ModuleController = function($scope, $routeParams, moduleManagement) {
		// default order settings
		$scope.order = 'bundleName';
		$scope.orderDesc = false;

		$scope.searchField = 'com.star';

		var e = moduleManagement.list.query(function() {
			$scope.modulelist = e;
		}, function(error) {
			$scope.error = error.status + " " + error.statusText;
		});

		$scope.sendcommand = function(bundleId, command) {
			moduleManagement.sendcommand.query({
				bundleId : bundleId,
				command : command
			}, function() {
				$scope.success = true;
				var e = moduleManagement.list.query(function() {
					$scope.modulelist = e;
				}, function(error) {
					$scope.error = error.status + " " + error.statusText;
				});
			}, function(error) {
				$scope.error = error.status + " " + error.statusText;
			});
		};
	};
	var RepositoryController = function($scope, $routeParams, repositoryManagement, messageManagement, $timeout, $route) {
		$scope.customTimer = function() {
			messageManagement.save.save({topic:'custom.repository.update'}, function() {
				$timeout(function () {
				    $route.reload();
				}, 500);
			}, function() {
				console.log('could not send custom event');
			});

		};

		$scope.repoavailable = true;
		$scope.selectedrepo = 'repo.starballsports.com';
		$scope.updateable = function(vl, vr) {
			if (vl == undefined) {
				return 2;// 'install';
			}
			if (vl == vr) {
				return 0;// 'gleich';
			}
			// 1
			var vl1 = parseInt(vl.substr(0, 1));
			var vr1 = parseInt(vr.substr(0, 1));
			if (vl1 < vr1) {
				return 1;// 'neu1';
			} else if (vl1 > vr1) {
				return -1;// 'alt1';
			}
			// 2
			var vl2 = parseInt(vl.substr(2, 1));
			var vr2 = parseInt(vr.substr(2, 1));
			if (vl2 < vr2) {
				return 1;// 'neu2';
			} else if (vl2 > vr2) {
				return -1;// 'alt2';
			}
			// 3
			var vl3 = parseInt(vl.substr(4, 1));
			var vr3 = parseInt(vr.substr(4, 1));
			if (vl3 < vr3) {
				return 1;// 'neu3';
			} else if (vl3 > vr3) {
				return -1;// 'alt3';
			}
			if (vl.length > vr.length) {
				return 1;// 'neu4';
			}
			return -1;// 'alt';
		};

		var e = repositoryManagement.list.query(function() {
			$scope.repoavailable = false;
			$scope.local = e.local;
			$scope.repolist = e;
			delete $scope.repolist.local;
			delete $scope.repolist.$promise;
			delete $scope.repolist.$resolved;
			$scope.selectedrepo = Object.keys($scope.repolist)[0];
			$scope.repokeys = [];
			var index;
			for (index = 0; index < $scope.local.length; ++index) {
				$scope.repoavailable = true;
				$scope.repokeys[$scope.local[index].name] = index;
			}

		}, function(error) {
			$scope.error = error.status + " " + error.statusText;
		});

		$scope.load = function(url) {
			repositoryManagement.sendcommand.query({
				bundleUrl : url
			}, function() {
				$scope.success = true;
			}, function(error) {
				$scope.error = error.status + " " + error.statusText;
			});
		};

	};

	var SideMenuController = function($scope, $location, $route) {
		$scope.isActive = function(path) {
			if ($route.current && $route.current.regexp) {
				return $route.current.regexp.test(path) || $location.path().startsWith(path);
			}
			return false;
		};

		$scope.menu = [ {
			"title" : "STARBASE",
			"data" : [ {
				"link" : "/main",
				"title" : "Dashboard"
			}, {
				"link" : "/config",
				"title" : "Configuration"
			}, {
				"link" : "/address",
				"title" : "Address Management"
			} ]
		}, {
			"title" : "Module",
			"data" : [ {
				"link" : "/module",
				"title" : "List loaded Modules"
			}, {
				"link" : "/repository",
				"title" : "Repository"
			}, {
				"link" : "/accessviolations",
				"title" : "Access Violations"
			} ]
		} ];
	};

	application.controller('MainController', MainController);
	application.controller('SideMenuController', SideMenuController);
	application.controller('ConfigController', ConfigController);
	application.controller('ConfigUpdateController', ConfigUpdateController);
	application.controller('AccessViolationsController', AccessViolationsController);
	application.controller('PermissionUpdateController', PermissionUpdateController);
	application.controller('AddressController', AddressController);
	application.controller('AddressUpdateController', AddressUpdateController);
	application.controller('ModuleController', ModuleController);
	application.controller('RepositoryController', RepositoryController);
}());
