(function() {
	var application = angular.module("STARBASE");

	application.factory("configManagement", function($resource) {
		return {
			list : $resource('../config/', {}, {
				query : {
					method : 'GET',
					isArray : true
				}
			}),
			detail : $resource('../config/:pid', {}, {
				query : {
					method : 'GET'
				}
			}),
			save : $resource('../config/:pid', {}, {
				save : {
					method : 'POST'
				}
			})
		};
	});
	application.factory("accessViolationManagement", function($resource) {
		return {
			list : $resource('../access', {}, {
				query : {
					method : 'GET'
				}
			})
		};
	});
	application.factory("permissionManagement", function($resource) {
		return {
			detail : $resource('../permission/:pid', {}, {
				query : {
					method : 'GET'
				}
			}),
			save : $resource('../permission/:pid', {}, {
				save : {
					method : 'POST'
				}
			})
		};
	});
	application.factory("addressManagement", function($resource) {
		return {
			list : $resource('../address/', {}, {
				query : {
					method : 'GET'
				}
			}),
			detail : $resource('../address/:pid', {}, {
				query : {
					method : 'GET'
				}
			}),
			save : $resource('../address/:pid', {}, {
				save : {
					method : 'POST'
				}
			}),
			remove : $resource('../address/:k', {k:'@k'}, {
				query : {
					method : 'DELETE'
				}
			})
		};
	});
	application.factory("moduleManagement", function($resource) {
		return {
			list : $resource('../module/', {}, {
				query : {
					method : 'GET',
					isArray : true
				}
			}),
			sendcommand : $resource('../module/', {}, {
				query : {
					method : 'POST'
				}
			})
		};
	});
	application.factory("repositoryManagement", function($resource) {
		return {
			list : $resource('../update/', {}, {
				query : {
					method : 'GET'
				}
			}),
			sendcommand : $resource('../update/', {}, {
				query : {
					method : 'POST'
				}
			})
		};
	});
	application.factory("messageManagement", function($resource) {
		return {
			save : $resource('../message/:topic', {topic:'@topic'}, {
				save : {
					method : 'POST'
				}
			})
		};
	});
}());
