/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.datastore.jsonfile.impl;

import com.starbase.core.Check;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.datastore.api.DataStoreService;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.service.datastore.jsonfile.Activator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class JSONFileDataStoreServiceImpl
implements DataStoreService,
ManagedService,
ConfiguredService,
MappingServiceAware {
    private static final String LF = "\n";
    private static final String ENCODING = "UTF-8";
    private static final String PATH = "path";
    private static final String SEP = "sep";
    private Hashtable<String, String> properties;
    private MappingService mappingService;

    public JSONFileDataStoreServiceImpl() {
        Enumeration<String> keys = this.getDefaultConfiguration().keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            this.properties.put(key, this.getDefaultConfiguration().get(key).toString());
        }
    }

    public <T> List<T> get(String key, Class<T> clazz) throws Exception {
        Check.serviceNotNull((Object[])new Object[]{this.mappingService});
        String jsonData = JSONFileDataStoreServiceImpl.readFile(this.getFilePath(key));
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.mappingService.mapToObject(jsonData, clazz));
        return list;
    }

    public <T> void store(String key, T value, Class<T> clazz) throws Exception {
        PrintWriter writer = new PrintWriter(this.getFilePath(key), ENCODING);
        writer.print(this.mappingService.mapToString(value));
        writer.close();
    }

    public boolean remove(String key) {
        try {
            File file = new File(this.getFilePath(key));
            Activator.getLog().log(3, "Deleting file " + file.getAbsolutePath() + ": " + file.delete());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void updated(Dictionary<String, ?> props) throws ConfigurationException {
        if (props == null) {
            return;
        }
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            this.properties.put(key, props.get(key).toString());
        }
        Activator.getLog().log(4, "updated json file store config: " + this.properties);
    }

    public Dictionary<String, ?> getDefaultConfiguration() {
        this.properties = new Hashtable();
        this.properties.put(PATH, "./store");
        this.properties.put(SEP, "/");
        this.properties.put("service.pid", "com.starbase.service.datastore.jsonfile");
        this.properties.put("ds_type", "persistent");
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String fileName) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(fileName));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(LF);
            }
            String string = sb.toString();
            return string;
        }
    }

    private String getFilePath(String key) {
        String directory = this.properties.get(PATH) + (this.properties.get(PATH).endsWith(this.properties.get(SEP)) ? "" : this.properties.get(SEP));
        File dir = new File(directory);
        if (!dir.exists()) {
            Activator.getLog().log(3, "given location (" + dir + ") does not exist, trying to create it");
            dir.mkdir();
        }
        if (!dir.isDirectory()) {
            Activator.getLog().log(1, "given location is not a directory and cannot be created");
        }
        return directory + key + ".json";
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
        Activator.getLog().log(3, "mapping service injected");
        Activator.getContext().registerService(DataStoreService.class, (Object)this, this.getDefaultConfiguration());
    }
}

