/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.echo.impl;

import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.service.io.echo.Activator;

public class EchoService
implements MessageConsumer,
AddressServiceAware,
CommunicationService,
MessagingServiceAware {
    private MessagingService messagingService;
    private AddressService addressService;

    public void push(EventDTO event, String topic) {
        AddressDTO toAddress = this.addressService.getAddress(event.getTo());
        this.sendMessage(toAddress, event);
    }

    public boolean sendMessage(AddressDTO address, EventDTO message) {
        Activator.getLog().log(3, "Sending message to: " + address.getTo() + ". CONTENT: " + message.getBody() + ". MODE: " + message.getCipherState());
        if (this.messagingService == null) {
            Activator.getLog().log(1, "MessagingService is null: .");
            return false;
        }
        if (message.getCipherState().equals((Object)CipherMode.PLAIN)) {
            Activator.getLog().log(3, "Publishing to: in.echo." + message.getTopic());
            return this.messagingService.publishMessage("in.echo." + message.getTopic(), message);
        }
        Activator.getLog().log(3, "Publishing to: " + message.getCipherState().toString().toLowerCase() + ".in.echo." + message.getTopic());
        return this.messagingService.publishMessage(message.getCipherState().toString().toLowerCase() + ".in.echo." + message.getTopic(), message);
    }

    public void setMessagingService(MessagingService messagingService) {
        Activator.getLog().log(4, "injecting messaging service");
        this.messagingService = messagingService;
    }

    public void setAddressService(AddressService addressService) {
        this.addressService = addressService;
    }
}

