/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.gpio;

import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.service.io.gpio.impl.GPIOServiceImpl;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;
    GPIOServiceImpl gpioService;

    public static BundleContext getContext() {
        return context;
    }

    public static LogService getLog() {
        return logServiceTracker == null ? null : logServiceTracker.getService();
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        this.gpioService = new GPIOServiceImpl();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.pid", "com.starbase.service.io.gpio");
        ((Dictionary)properties).put("topic", new String[]{"out.gpio.*"});
        context.registerService(new String[]{AddressServiceAware.class.getName(), MessageConsumer.class.getName(), CommunicationService.class.getName(), MappingServiceAware.class.getName()}, (Object)this.gpioService, properties);
        Activator.getLog().log(4, "GPIO Bundle started. GPIO Instance initialized.");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.gpioService.unprovisionPins();
        this.gpioService.getGpio().shutdown();
        Activator.getLog().log(4, "Stopping GPIO Bundle. Closing GPIO Instance.");
        logServiceTracker.close();
        context = null;
    }
}

