/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.gpio.impl;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.wiringpi.Gpio;
import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.core.types.StarbaseType;
import com.starbase.core.types.bmengine.DimDTO;
import com.starbase.core.types.bmengine.PwmDTO;
import com.starbase.core.types.bmengine.SwitchDTO;
import com.starbase.service.io.gpio.Activator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;

public class GPIOServiceImpl
implements MessageConsumer,
AddressServiceAware,
CommunicationService,
MappingServiceAware {
    static GpioPin gpio00 = null;
    static GpioPin gpio01 = null;
    static GpioPin gpio02 = null;
    static GpioPin gpio03 = null;
    static GpioPin gpio04 = null;
    static GpioPin gpio05 = null;
    static GpioPin gpio06 = null;
    static GpioPin gpio07 = null;
    static GpioPin gpio08 = null;
    static GpioPin gpio09 = null;
    static GpioPin gpio10 = null;
    static GpioPin gpio11 = null;
    static GpioPin gpio12 = null;
    static GpioPin gpio13 = null;
    static GpioPin gpio14 = null;
    static GpioPin gpio15 = null;
    static GpioPin gpio16 = null;
    static GpioPin gpio17 = null;
    static GpioPin gpio18 = null;
    static GpioPin gpio19 = null;
    static GpioPin gpio20 = null;
    static GpioPin gpio21 = null;
    static GpioPin gpio22 = null;
    static GpioPin gpio23 = null;
    static GpioPin gpio24 = null;
    static GpioPin gpio25 = null;
    static GpioPin gpio26 = null;
    static GpioPin gpio27 = null;
    static GpioPin gpio28 = null;
    static GpioPin gpio29 = null;
    static GpioPin gpio30 = null;
    static GpioPin gpio31 = null;
    private static HashMap<String, GpioPin> gpioPins = null;
    private Dictionary<String, ?> configProperties;
    private AddressService addressService;
    private MappingService mappingService;
    private static GpioController gpio;

    public GPIOServiceImpl() {
        gpio = GpioFactory.getInstance();
        gpioPins = new HashMap();
    }

    public GpioController getGpio() {
        return gpio;
    }

    public void unprovisionPins() {
        for (Map.Entry<String, GpioPin> entry : gpioPins.entrySet()) {
            GpioPin pin = entry.getValue();
            gpio.unprovisionPin(new GpioPin[]{pin});
            gpioPins.remove(entry);
        }
    }

    public void push(EventDTO event, String topic) {
        AddressDTO toAddress = this.addressService.getAddress(event.getTo());
        this.sendMessage(toAddress, event);
    }

    private static GpioPin mapStringToGpioOutput(String gpioString, PinMode pinmode) {
        if (gpioString.equals("GPIO_00")) {
            gpio00 = GPIOServiceImpl.getOutputPin(gpio00, RaspiPin.GPIO_00, pinmode);
            return gpio00;
        }
        if (gpioString.equals("GPIO_01")) {
            gpio01 = GPIOServiceImpl.getOutputPin(gpio01, RaspiPin.GPIO_01, pinmode);
            return gpio01;
        }
        if (gpioString.equals("GPIO_02")) {
            gpio02 = GPIOServiceImpl.getOutputPin(gpio02, RaspiPin.GPIO_02, pinmode);
            return gpio02;
        }
        if (gpioString.equals("GPIO_03")) {
            gpio03 = GPIOServiceImpl.getOutputPin(gpio03, RaspiPin.GPIO_03, pinmode);
            return gpio03;
        }
        if (gpioString.equals("GPIO_04")) {
            gpio04 = GPIOServiceImpl.getOutputPin(gpio04, RaspiPin.GPIO_04, pinmode);
            return gpio04;
        }
        if (gpioString.equals("GPIO_05")) {
            gpio05 = GPIOServiceImpl.getOutputPin(gpio05, RaspiPin.GPIO_05, pinmode);
            return gpio05;
        }
        if (gpioString.equals("GPIO_06")) {
            gpio06 = GPIOServiceImpl.getOutputPin(gpio06, RaspiPin.GPIO_06, pinmode);
            return gpio06;
        }
        if (gpioString.equals("GPIO_07")) {
            gpio07 = GPIOServiceImpl.getOutputPin(gpio07, RaspiPin.GPIO_07, pinmode);
            return gpio07;
        }
        if (gpioString.equals("GPIO_08")) {
            gpio08 = GPIOServiceImpl.getOutputPin(gpio08, RaspiPin.GPIO_08, pinmode);
            return gpio08;
        }
        if (gpioString.equals("GPIO_09")) {
            gpio09 = GPIOServiceImpl.getOutputPin(gpio09, RaspiPin.GPIO_09, pinmode);
            return gpio09;
        }
        if (gpioString.equals("GPIO_10")) {
            gpio10 = GPIOServiceImpl.getOutputPin(gpio10, RaspiPin.GPIO_10, pinmode);
            return gpio10;
        }
        if (gpioString.equals("GPIO_11")) {
            gpio11 = GPIOServiceImpl.getOutputPin(gpio11, RaspiPin.GPIO_11, pinmode);
            return gpio11;
        }
        if (gpioString.equals("GPIO_12")) {
            gpio12 = GPIOServiceImpl.getOutputPin(gpio12, RaspiPin.GPIO_12, pinmode);
            return gpio12;
        }
        if (gpioString.equals("GPIO_13")) {
            gpio13 = GPIOServiceImpl.getOutputPin(gpio13, RaspiPin.GPIO_13, pinmode);
            return gpio13;
        }
        if (gpioString.equals("GPIO_14")) {
            gpio14 = GPIOServiceImpl.getOutputPin(gpio14, RaspiPin.GPIO_14, pinmode);
            return gpio14;
        }
        if (gpioString.equals("GPIO_15")) {
            gpio15 = GPIOServiceImpl.getOutputPin(gpio15, RaspiPin.GPIO_15, pinmode);
            return gpio15;
        }
        if (gpioString.equals("GPIO_16")) {
            gpio16 = GPIOServiceImpl.getOutputPin(gpio16, RaspiPin.GPIO_16, pinmode);
            return gpio16;
        }
        if (gpioString.equals("GPIO_17")) {
            gpio17 = GPIOServiceImpl.getOutputPin(gpio17, RaspiPin.GPIO_17, pinmode);
            return gpio17;
        }
        if (gpioString.equals("GPIO_18")) {
            gpio18 = GPIOServiceImpl.getOutputPin(gpio18, RaspiPin.GPIO_18, pinmode);
            return gpio18;
        }
        if (gpioString.equals("GPIO_19")) {
            gpio19 = GPIOServiceImpl.getOutputPin(gpio19, RaspiPin.GPIO_19, pinmode);
            return gpio19;
        }
        if (gpioString.equals("GPIO_20")) {
            gpio20 = GPIOServiceImpl.getOutputPin(gpio20, RaspiPin.GPIO_20, pinmode);
            return gpio20;
        }
        if (gpioString.equals("GPIO_21")) {
            gpio21 = GPIOServiceImpl.getOutputPin(gpio21, RaspiPin.GPIO_21, pinmode);
            return gpio21;
        }
        if (gpioString.equals("GPIO_22")) {
            gpio22 = GPIOServiceImpl.getOutputPin(gpio22, RaspiPin.GPIO_22, pinmode);
            return gpio22;
        }
        if (gpioString.equals("GPIO_23")) {
            gpio23 = GPIOServiceImpl.getOutputPin(gpio23, RaspiPin.GPIO_23, pinmode);
            return gpio23;
        }
        if (gpioString.equals("GPIO_24")) {
            gpio24 = GPIOServiceImpl.getOutputPin(gpio24, RaspiPin.GPIO_24, pinmode);
            return gpio24;
        }
        if (gpioString.equals("GPIO_25")) {
            gpio25 = GPIOServiceImpl.getOutputPin(gpio25, RaspiPin.GPIO_25, pinmode);
            return gpio25;
        }
        if (gpioString.equals("GPIO_26")) {
            gpio26 = GPIOServiceImpl.getOutputPin(gpio26, RaspiPin.GPIO_26, pinmode);
            return gpio26;
        }
        if (gpioString.equals("GPIO_27")) {
            gpio27 = GPIOServiceImpl.getOutputPin(gpio27, RaspiPin.GPIO_27, pinmode);
            return gpio27;
        }
        if (gpioString.equals("GPIO_28")) {
            gpio28 = GPIOServiceImpl.getOutputPin(gpio28, RaspiPin.GPIO_28, pinmode);
            return gpio28;
        }
        if (gpioString.equals("GPIO_29")) {
            gpio29 = GPIOServiceImpl.getOutputPin(gpio29, RaspiPin.GPIO_29, pinmode);
            return gpio29;
        }
        if (gpioString.equals("GPIO_30")) {
            gpio30 = GPIOServiceImpl.getOutputPin(gpio30, RaspiPin.GPIO_30, pinmode);
            return gpio30;
        }
        if (gpioString.equals("GPIO_31")) {
            gpio31 = GPIOServiceImpl.getOutputPin(gpio31, RaspiPin.GPIO_31, pinmode);
            return gpio31;
        }
        return null;
    }

    private static GpioPin getOutputPin(GpioPin gpioPin, Pin pin, PinMode pinmode) {
        if (gpioPin == null) {
            if (pinmode.equals((Object)PinMode.PWM_OUTPUT)) {
                return gpio.provisionPwmOutputPin(pin);
            }
            if (pinmode.equals((Object)PinMode.SOFT_PWM_OUTPUT)) {
                return gpio.provisionSoftPwmOutputPin(pin);
            }
            if (pinmode.equals((Object)PinMode.DIGITAL_OUTPUT)) {
                return gpio.provisionDigitalOutputPin(pin);
            }
            if (pinmode.equals((Object)PinMode.ANALOG_OUTPUT)) {
                return gpio.provisionAnalogOutputPin(pin);
            }
            return null;
        }
        if (gpioPin.getMode().equals((Object)pinmode)) {
            return gpioPin;
        }
        gpio.shutdown();
        gpio.unprovisionPin(new GpioPin[]{gpioPin});
        if (pinmode.equals((Object)PinMode.PWM_OUTPUT)) {
            return gpio.provisionPwmOutputPin(pin);
        }
        if (pinmode.equals((Object)PinMode.SOFT_PWM_OUTPUT)) {
            return gpio.provisionSoftPwmOutputPin(pin);
        }
        if (pinmode.equals((Object)PinMode.DIGITAL_OUTPUT)) {
            return gpio.provisionDigitalOutputPin(pin);
        }
        if (pinmode.equals((Object)PinMode.ANALOG_OUTPUT)) {
            return gpio.provisionAnalogOutputPin(pin);
        }
        return null;
    }

    public boolean sendMessage(AddressDTO address, EventDTO message) {
        String gpioName = address.getTo();
        StarbaseType type = null;
        try {
            type = (StarbaseType)this.mappingService.mapToObject(message.getBody(), "type");
        }
        catch (Exception e) {
            Activator.getLog().log(1, "Cannot map body of EventDTO to StarbaseType", (Throwable)e);
        }
        if (type.getClass().equals(PwmDTO.class)) {
            PwmDTO pwmDTO = (PwmDTO)type;
            GpioPinPwmOutput pwm = (GpioPinPwmOutput)GPIOServiceImpl.mapStringToGpioOutput(gpioName, PinMode.PWM_OUTPUT);
            Gpio.pwmSetMode((int)0);
            Gpio.pwmSetRange((int)pwmDTO.getRange());
            Gpio.pwmSetClock((int)pwmDTO.getClock());
            pwm.setPwm(pwmDTO.getHigh());
        } else if (type.getClass().equals(DimDTO.class)) {
            DimDTO dimDTO = (DimDTO)type;
            if (dimDTO.getIntensity() < 0 || dimDTO.getIntensity() > 100) {
                Activator.getLog().log(2, "The chosen PWM intensity " + dimDTO.getIntensity() + " percent is out of the allowed range 0-100 percent.");
                return false;
            }
            if (gpioName.equals("GPIO_01") || gpioName.equals("GPIO_23") || gpioName.equals("GPIO_24") || gpioName.equals("GPIO_26")) {
                GpioPinPwmOutput pwm = (GpioPinPwmOutput)GPIOServiceImpl.mapStringToGpioOutput(gpioName, PinMode.PWM_OUTPUT);
                Gpio.pwmSetMode((int)0);
                Gpio.pwmSetRange((int)1000);
                Gpio.pwmSetClock((int)200);
                pwm.setPwm(dimDTO.getIntensity() * 10);
                Activator.getLog().log(4, "Using " + gpioName + " in hard PWM mode with " + dimDTO.getIntensity() + " percent intensity.");
            } else {
                GpioPinPwmOutput pwm = (GpioPinPwmOutput)GPIOServiceImpl.mapStringToGpioOutput(gpioName, PinMode.SOFT_PWM_OUTPUT);
                pwm.setPwm(dimDTO.getIntensity());
                Activator.getLog().log(4, "Using " + gpioName + " in soft PWM mode with " + dimDTO.getIntensity() + " percent intensity.");
            }
        } else if (type.getClass().equals(SwitchDTO.class)) {
            SwitchDTO switchDTO = (SwitchDTO)type;
            GpioPinDigitalOutput pin = (GpioPinDigitalOutput)GPIOServiceImpl.mapStringToGpioOutput(gpioName, PinMode.DIGITAL_OUTPUT);
            if (switchDTO.getState().equals((Object)SwitchDTO.State.ON)) {
                pin.setState(true);
                Activator.getLog().log(4, "Turning ON " + gpioName);
            } else if (switchDTO.getState().equals((Object)SwitchDTO.State.OFF)) {
                pin.setState(false);
                Activator.getLog().log(4, "Turning OFF " + gpioName);
            }
        } else {
            Activator.getLog().log(1, "Invalid type " + type.getClass() + " for GPIO Communication Service ");
            return false;
        }
        return true;
    }

    public void setAddressService(AddressService addressService) {
        this.addressService = addressService;
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }
}

